/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.util.HashMap;
import java.util.Map;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.ChangeLogParser;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.LiquibaseService;

@LiquibaseService(skip=true)
public class MockChangeLogParser
implements ChangeLogParser {
    private String[] validExtensions;
    public Map<String, DatabaseChangeLog> changeLogs = new HashMap<String, DatabaseChangeLog>();

    public MockChangeLogParser() {
    }

    public MockChangeLogParser(String ... validExtensions) {
        this.validExtensions = validExtensions;
    }

    public int getPriority() {
        return 1;
    }

    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        if (this.changeLogs.containsKey(changeLogFile)) {
            return true;
        }
        for (String ext : this.validExtensions) {
            if (!changeLogFile.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        return this.changeLogs.get(physicalChangeLogLocation);
    }
}

