/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition;

import java.util.Map;
import liquibase.precondition.MockPrecondition;
import liquibase.precondition.Precondition;
import liquibase.precondition.PreconditionFactory;
import liquibase.precondition.core.AndPrecondition;
import liquibase.precondition.core.OrPrecondition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PreconditionFactoryTest {
    @Before
    public void setup() {
        PreconditionFactory.reset();
    }

    @After
    public void after() {
        PreconditionFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)PreconditionFactory.getInstance());
        Assert.assertSame((Object)PreconditionFactory.getInstance(), (Object)PreconditionFactory.getInstance());
    }

    @Test
    public void register() {
        PreconditionFactory.getInstance().getPreconditions().clear();
        Assert.assertEquals((long)0L, (long)PreconditionFactory.getInstance().getPreconditions().size());
        PreconditionFactory.getInstance().register((Precondition)new MockPrecondition());
        Assert.assertEquals((long)1L, (long)PreconditionFactory.getInstance().getPreconditions().size());
    }

    @Test
    public void unregister_instance() {
        PreconditionFactory factory = PreconditionFactory.getInstance();
        factory.getPreconditions().clear();
        Assert.assertEquals((long)0L, (long)factory.getPreconditions().size());
        factory.register((Precondition)new OrPrecondition());
        factory.register((Precondition)new AndPrecondition());
        Assert.assertEquals((long)2L, (long)factory.getPreconditions().size());
        factory.unregister("and");
        Assert.assertEquals((long)1L, (long)factory.getPreconditions().size());
    }

    @Test
    public void reset() {
        PreconditionFactory instance1 = PreconditionFactory.getInstance();
        PreconditionFactory.reset();
        Assert.assertNotSame((Object)instance1, (Object)PreconditionFactory.getInstance());
    }

    @Test
    public void builtInGeneratorsAreFound() {
        Map generators = PreconditionFactory.getInstance().getPreconditions();
        Assert.assertTrue((generators.size() > 5 ? 1 : 0) != 0);
    }

    @Test
    public void createPreconditions() {
        Precondition precondtion = PreconditionFactory.getInstance().create("and");
        Assert.assertNotNull((Object)precondtion);
        Assert.assertTrue((boolean)(precondtion instanceof AndPrecondition));
    }
}

