/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer;

import java.util.List;
import java.util.Map;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.serializer.MockChangeLogSerializer;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.serializer.core.xml.XMLChangeLogSerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeLogSerializerFactoryTest {
    @Before
    public void setUp() {
        ChangeLogSerializerFactory.reset();
    }

    @After
    public void tearDown() {
        ChangeLogSerializerFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)ChangeLogSerializerFactory.getInstance());
        Assert.assertSame((Object)ChangeLogSerializerFactory.getInstance(), (Object)ChangeLogSerializerFactory.getInstance());
    }

    @Test
    public void register() {
        ChangeLogSerializerFactory.getInstance().getSerializers().clear();
        Assert.assertEquals((long)0L, (long)ChangeLogSerializerFactory.getInstance().getSerializers().size());
        ChangeLogSerializerFactory.getInstance().register((ChangeLogSerializer)new MockChangeLogSerializer("mock"));
        Assert.assertEquals((long)1L, (long)ChangeLogSerializerFactory.getInstance().getSerializers().size());
    }

    @Test
    public void unregister_instance() {
        ChangeLogSerializerFactory factory = ChangeLogSerializerFactory.getInstance();
        factory.getSerializers().clear();
        Assert.assertEquals((long)0L, (long)factory.getSerializers().size());
        XMLChangeLogSerializer changeLogSerializer = new XMLChangeLogSerializer();
        factory.register((ChangeLogSerializer)new StringChangeLogSerializer());
        factory.register((ChangeLogSerializer)changeLogSerializer);
        Assert.assertEquals((long)2L, (long)factory.getSerializers().size());
        factory.unregister((ChangeLogSerializer)changeLogSerializer);
        Assert.assertEquals((long)1L, (long)factory.getSerializers().size());
    }

    @Test
    public void reset() {
        ChangeLogSerializerFactory instance1 = ChangeLogSerializerFactory.getInstance();
        ChangeLogSerializerFactory.reset();
        Assert.assertNotSame((Object)instance1, (Object)ChangeLogSerializerFactory.getInstance());
    }

    @Test
    public void builtInSerializersAreFound() {
        Map serializers = ChangeLogSerializerFactory.getInstance().getSerializers();
        Assert.assertEquals((long)6L, (long)serializers.size());
    }

    @Test
    public void getSerializers() {
        ChangeLogSerializer serializer = ChangeLogSerializerFactory.getInstance().getSerializer("xml");
        Assert.assertNotNull((Object)serializer);
        Assert.assertSame(XMLChangeLogSerializer.class, serializer.getClass());
        Assert.assertEquals((long)1L, (long)ChangeLogSerializerFactory.getInstance().getSerializers("xml").size());
    }

    @Test
    public void highestPrioritySerializerReturned() {
        ChangeLogSerializerFactory factory = ChangeLogSerializerFactory.getInstance();
        XMLChangeLogSerializer highestPriority = new XMLChangeLogSerializer(){

            public int getPriority() {
                return super.getPriority() + 4;
            }
        };
        factory.register((ChangeLogSerializer)highestPriority);
        XMLChangeLogSerializer higherPriority = new XMLChangeLogSerializer(){

            public int getPriority() {
                return super.getPriority() + 1;
            }
        };
        factory.register((ChangeLogSerializer)higherPriority);
        Assert.assertSame((Object)highestPriority, (Object)factory.getSerializer("xml"));
        Assert.assertEquals((long)3L, (long)((List)factory.getSerializers().get("xml")).size());
    }
}

