/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.json;

import java.util.Calendar;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.core.AddColumnChange;
import liquibase.changelog.ChangeSet;
import liquibase.precondition.Precondition;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.core.json.JsonChangeLogSerializer;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceNextValueFunction;
import org.junit.Assert;
import org.junit.Test;

public class JsonChangeLogSerializerTest {
    private String origTimeZone = System.getProperty("user.timezone");

    @Test
    public void serialize_changeSet() {
        AddColumnChange addColumnChange = new AddColumnChange();
        addColumnChange.setCatalogName("cat");
        addColumnChange.addColumn((AddColumnConfig)new AddColumnConfig().setName("col1").setDefaultValueNumeric((Number)3));
        addColumnChange.addColumn((AddColumnConfig)new AddColumnConfig().setName("col2").setDefaultValueComputed(new DatabaseFunction("NOW()")));
        addColumnChange.addColumn((AddColumnConfig)new AddColumnConfig().setName("col3").setDefaultValueBoolean(Boolean.valueOf(true)));
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        cal.set(1970, 0, 1, 0, 0, 0);
        addColumnChange.addColumn((AddColumnConfig)new AddColumnConfig().setName("col2").setDefaultValueDate(cal.getTime()));
        addColumnChange.addColumn((AddColumnConfig)new AddColumnConfig().setName("col2").setDefaultValueSequenceNext(new SequenceNextValueFunction("seq_me")));
        ChangeSet changeSet = new ChangeSet("1", "nvoxland", false, false, "path/to/file.json", null, null, false, null);
        changeSet.setPreconditions(this.newSamplePreconditions());
        changeSet.setRunOrder("last");
        changeSet.setIgnore(true);
        changeSet.addChange((Change)addColumnChange);
        String serializedJson = new JsonChangeLogSerializer().serialize((LiquibaseSerializable)changeSet, true);
        Assert.assertEquals((Object)"{\n  \"changeSet\": {\n    \"id\": \"1\",\n    \"author\": \"nvoxland\",\n    \"ignore\": true,\n    \"objectQuotingStrategy\": \"LEGACY\",\n    \"preconditions\": {\n      \"preConditions\": {\n        \"nestedPreconditions\": [\n          {\n            \"preConditions\": {\n              \"onError\": \"WARN\",\n              \"onFail\": \"CONTINUE\",\n              \"onSqlOutput\": \"TEST\"\n            }\n          }\n        ]\n        ,\n        \"onError\": \"CONTINUE\",\n        \"onFail\": \"MARK_RAN\",\n        \"onSqlOutput\": \"FAIL\"\n      }\n    },\n    \"runInTransaction\": false,\n    \"runOrder\": \"last\",\n    \"changes\": [\n      {\n        \"addColumn\": {\n          \"catalogName\": \"cat\",\n          \"columns\": [\n            {\n              \"column\": {\n                \"defaultValueNumeric\": 3,\n                \"name\": \"col1\"\n              }\n            },\n            {\n              \"column\": {\n                \"defaultValueComputed\": \"NOW()\",\n                \"name\": \"col2\"\n              }\n            },\n            {\n              \"column\": {\n                \"defaultValueBoolean\": true,\n                \"name\": \"col3\"\n              }\n            },\n            {\n              \"column\": {\n                \"defaultValueDate\": \"1970-01-01T00:00:00\",\n                \"name\": \"col2\"\n              }\n            },\n            {\n              \"column\": {\n                \"defaultValueSequenceNext\": \"seq_me\",\n                \"name\": \"col2\"\n              }\n            }\n          ]\n          \n        }\n      }\n    ]\n    \n  }\n}\n", (Object)serializedJson);
    }

    private PreconditionContainer newSamplePreconditions() {
        PreconditionContainer precondition = new PreconditionContainer();
        precondition.setOnError(PreconditionContainer.ErrorOption.CONTINUE);
        precondition.setOnFail(PreconditionContainer.FailOption.MARK_RAN);
        precondition.setOnSqlOutput(PreconditionContainer.OnSqlOutputOption.FAIL);
        PreconditionContainer nestedPrecondition = new PreconditionContainer();
        nestedPrecondition.setOnError(PreconditionContainer.ErrorOption.WARN);
        nestedPrecondition.setOnFail(PreconditionContainer.FailOption.CONTINUE);
        nestedPrecondition.setOnSqlOutput(PreconditionContainer.OnSqlOutputOption.TEST);
        precondition.addNestedPrecondition((Precondition)nestedPrecondition);
        return precondition;
    }
}

