/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.xml;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import liquibase.Labels;
import liquibase.change.AddColumnConfig;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AddAutoIncrementChange;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AddDefaultValueChange;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.AddNotNullConstraintChange;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.change.core.AddUniqueConstraintChange;
import liquibase.change.core.AlterSequenceChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateProcedureChange;
import liquibase.change.core.CreateSequenceChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.change.core.DropIndexChange;
import liquibase.change.core.DropNotNullConstraintChange;
import liquibase.change.core.DropPrimaryKeyChange;
import liquibase.change.core.DropSequenceChange;
import liquibase.change.core.DropTableChange;
import liquibase.change.core.DropUniqueConstraintChange;
import liquibase.change.core.DropViewChange;
import liquibase.change.core.InsertDataChange;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.RawSQLChange;
import liquibase.change.core.RenameColumnChange;
import liquibase.change.core.RenameSequenceChange;
import liquibase.change.core.RenameTableChange;
import liquibase.change.core.RenameViewChange;
import liquibase.change.core.SQLFileChange;
import liquibase.change.core.TagDatabaseChange;
import liquibase.change.core.UpdateDataChange;
import liquibase.change.custom.CustomChangeWrapper;
import liquibase.changelog.ChangeSet;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.precondition.CustomPreconditionWrapper;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.core.xml.XMLChangeLogSerializer;
import liquibase.statement.SequenceNextValueFunction;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLChangeLogSerializerTest {
    @Test
    public void createNode_addAutoIncrementChange() throws Exception {
        AddAutoIncrementChange change = new AddAutoIncrementChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setColumnDataType("DATATYPE(255)");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"addAutoIncrement", (Object)node.getTagName());
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if ("schemaName".equals(attribute.getNodeName())) {
                Assert.assertEquals((Object)"SCHEMA_NAME", (Object)attribute.getNodeValue());
                continue;
            }
            if ("tableName".equals(attribute.getNodeName())) {
                Assert.assertEquals((Object)"TABLE_NAME", (Object)attribute.getNodeValue());
                continue;
            }
            if ("columnName".equals(attribute.getNodeName())) {
                Assert.assertEquals((Object)"COLUMN_NAME", (Object)attribute.getNodeValue());
                continue;
            }
            if ("columnDataType".equals(attribute.getNodeName())) {
                Assert.assertEquals((Object)"DATATYPE(255)", (Object)attribute.getNodeValue());
                continue;
            }
            Assert.fail((String)("unexpected attribute " + attribute.getNodeName()));
        }
    }

    @Test
    public void createNode_addColumnChange() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setTableName("TAB");
        AddColumnConfig column = new AddColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        refactoring.addColumn(column);
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"addColumn", (Object)node.getTagName());
        Assert.assertEquals((Object)"TAB", (Object)node.getAttribute("tableName"));
        NodeList columns = node.getElementsByTagName("column");
        Assert.assertEquals((long)1L, (long)columns.getLength());
        Assert.assertEquals((Object)"column", (Object)((Element)columns.item(0)).getTagName());
        Assert.assertEquals((Object)"NEWCOL", (Object)((Element)columns.item(0)).getAttribute("name"));
        Assert.assertEquals((Object)"TYP", (Object)((Element)columns.item(0)).getAttribute("type"));
    }

    @Test
    public void createNode_AddDefaultValueChange() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValue("DEF STRING");
        change.setDefaultValueNumeric("42");
        change.setDefaultValueBoolean(Boolean.valueOf(true));
        change.setDefaultValueDate("2007-01-02");
        change.setDefaultValueSequenceNext(new SequenceNextValueFunction("sampleSeq"));
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"addDefaultValue", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"COLUMN_NAME", (Object)node.getAttribute("columnName"));
        Assert.assertEquals((Object)"DEF STRING", (Object)node.getAttribute("defaultValue"));
        Assert.assertEquals((Object)"42", (Object)node.getAttribute("defaultValueNumeric"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("defaultValueBoolean"));
        Assert.assertEquals((Object)"2007-01-02", (Object)node.getAttribute("defaultValueDate"));
        Assert.assertEquals((Object)"sampleSeq", (Object)node.getAttribute("defaultValueSequenceNext"));
    }

    @Test
    public void createNode_AddForeignKeyConstraintChange() throws Exception {
        AddForeignKeyConstraintChange change = new AddForeignKeyConstraintChange();
        change.setConstraintName("FK_NAME");
        change.setBaseTableSchemaName("BASE_SCHEMA_NAME");
        change.setBaseTableName("BASE_TABLE_NAME");
        change.setBaseColumnNames("BASE_COL_NAME");
        change.setReferencedTableSchemaName("REF_SCHEMA_NAME");
        change.setReferencedTableName("REF_TABLE_NAME");
        change.setReferencedColumnNames("REF_COL_NAME");
        change.setDeferrable(Boolean.valueOf(true));
        change.setOnDelete("CASCADE");
        change.setOnUpdate("CASCADE");
        change.setInitiallyDeferred(Boolean.valueOf(true));
        change.setValidate(Boolean.valueOf(true));
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"addForeignKeyConstraint", (Object)node.getTagName());
        Assert.assertEquals((Object)"FK_NAME", (Object)node.getAttribute("constraintName"));
        Assert.assertEquals((Object)"BASE_SCHEMA_NAME", (Object)node.getAttribute("baseTableSchemaName"));
        Assert.assertEquals((Object)"BASE_TABLE_NAME", (Object)node.getAttribute("baseTableName"));
        Assert.assertEquals((Object)"BASE_COL_NAME", (Object)node.getAttribute("baseColumnNames"));
        Assert.assertEquals((Object)"REF_SCHEMA_NAME", (Object)node.getAttribute("referencedTableSchemaName"));
        Assert.assertEquals((Object)"REF_TABLE_NAME", (Object)node.getAttribute("referencedTableName"));
        Assert.assertEquals((Object)"REF_COL_NAME", (Object)node.getAttribute("referencedColumnNames"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("deferrable"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("initiallyDeferred"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("validate"));
        Assert.assertEquals((Object)"CASCADE", (Object)node.getAttribute("onDelete"));
        Assert.assertEquals((Object)"CASCADE", (Object)node.getAttribute("onUpdate"));
    }

    @Test
    public void createNode_AddNotNullConstraintChange() throws Exception {
        AddNotNullConstraintChange change = new AddNotNullConstraintChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_HERE");
        change.setDefaultNullValue("DEFAULT_VALUE");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"addNotNullConstraint", (Object)node.getTagName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"COL_HERE", (Object)node.getAttribute("columnName"));
        Assert.assertEquals((Object)"DEFAULT_VALUE", (Object)node.getAttribute("defaultNullValue"));
    }

    @Test
    public void createNode_AddPrimaryKeyChange() throws Exception {
        AddPrimaryKeyChange change = new AddPrimaryKeyChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnNames("COL_HERE");
        change.setConstraintName("PK_NAME");
        change.setTablespace("TABLESPACE_NAME");
        change.setValidate(Boolean.valueOf(true));
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"addPrimaryKey", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"COL_HERE", (Object)node.getAttribute("columnNames"));
        Assert.assertEquals((Object)"PK_NAME", (Object)node.getAttribute("constraintName"));
        Assert.assertEquals((Object)"TABLESPACE_NAME", (Object)node.getAttribute("tablespace"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("validate"));
    }

    @Test
    public void createNode_AddUniqueConstraintChange() throws Exception {
        AddUniqueConstraintChange change = new AddUniqueConstraintChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnNames("COL_HERE");
        change.setConstraintName("PK_NAME");
        change.setTablespace("TABLESPACE_NAME");
        change.setDeferrable(Boolean.valueOf(true));
        change.setValidate(Boolean.valueOf(true));
        change.setInitiallyDeferred(Boolean.valueOf(true));
        change.setDisabled(Boolean.valueOf(true));
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"addUniqueConstraint", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"COL_HERE", (Object)node.getAttribute("columnNames"));
        Assert.assertEquals((Object)"PK_NAME", (Object)node.getAttribute("constraintName"));
        Assert.assertEquals((Object)"TABLESPACE_NAME", (Object)node.getAttribute("tablespace"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("disabled"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("deferrable"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("initiallyDeferred"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("validate"));
    }

    @Test
    public void createNode_AlterSequenceChange_nullValues() throws Exception {
        AlterSequenceChange refactoring = new AlterSequenceChange();
        refactoring.setSequenceName("SEQ_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"alterSequence", (Object)node.getNodeName());
        Assert.assertEquals((Object)"SEQ_NAME", (Object)node.getAttribute("sequenceName"));
        Assert.assertFalse((boolean)node.hasAttribute("incrementBy"));
        Assert.assertFalse((boolean)node.hasAttribute("maxValue"));
        Assert.assertFalse((boolean)node.hasAttribute("minValue"));
        Assert.assertFalse((boolean)node.hasAttribute("ordered"));
    }

    @Test
    public void createNode_AlterSequenceChange() throws Exception {
        AlterSequenceChange refactoring = new AlterSequenceChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setSequenceName("SEQ_NAME");
        refactoring.setIncrementBy(new BigInteger("1"));
        refactoring.setMaxValue(new BigInteger("2"));
        refactoring.setMinValue(new BigInteger("3"));
        refactoring.setOrdered(Boolean.valueOf(true));
        refactoring.setCacheSize(new BigInteger("2008"));
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"alterSequence", (Object)node.getNodeName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"SEQ_NAME", (Object)node.getAttribute("sequenceName"));
        Assert.assertEquals((Object)"1", (Object)node.getAttribute("incrementBy"));
        Assert.assertEquals((Object)"2", (Object)node.getAttribute("maxValue"));
        Assert.assertEquals((Object)"3", (Object)node.getAttribute("minValue"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("ordered"));
        Assert.assertEquals((Object)"2008", (Object)node.getAttribute("cacheSize"));
    }

    @Test
    public void createNode_ColumnConfig() throws Exception {
        ColumnConfig column = new ColumnConfig();
        column.setName("id");
        column.setType("varchar(255)");
        column.setDefaultValue("test Value");
        column.setValue("some value here");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setDeferrable(Boolean.TRUE);
        constraints.setValidateNullable(Boolean.TRUE);
        constraints.setValidateUnique(Boolean.TRUE);
        constraints.setValidatePrimaryKey(Boolean.TRUE);
        constraints.setValidateForeignKey(Boolean.TRUE);
        constraints.setDeleteCascade(Boolean.valueOf(true));
        constraints.setForeignKeyName("FK_NAME");
        constraints.setInitiallyDeferred(Boolean.valueOf(true));
        constraints.setNullable(Boolean.valueOf(false));
        constraints.setPrimaryKey(Boolean.valueOf(true));
        constraints.setReferences("state(id)");
        constraints.setUnique(Boolean.valueOf(true));
        column.setConstraints(constraints);
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode(column);
        Assert.assertEquals((Object)"column", (Object)element.getTagName());
        Assert.assertEquals((Object)"id", (Object)element.getAttribute("name"));
        Assert.assertEquals((Object)"varchar(255)", (Object)element.getAttribute("type"));
        Assert.assertEquals((Object)"test Value", (Object)element.getAttribute("defaultValue"));
        Assert.assertEquals((Object)"some value here", (Object)element.getAttribute("value"));
        Element constraintsElement = (Element)element.getChildNodes().item(0);
        Assert.assertEquals((long)12L, (long)constraintsElement.getAttributes().getLength());
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("deferrable"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("validateNullable"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("validateUnique"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("validatePrimaryKey"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("validateForeignKey"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("deleteCascade"));
        Assert.assertEquals((Object)"FK_NAME", (Object)constraintsElement.getAttribute("foreignKeyName"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("initiallyDeferred"));
        Assert.assertEquals((Object)"false", (Object)constraintsElement.getAttribute("nullable"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("primaryKey"));
        Assert.assertEquals((Object)"state(id)", (Object)constraintsElement.getAttribute("references"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("unique"));
    }

    @Test
    public void createNode_CreateIndexChange() throws Exception {
        CreateIndexChange refactoring = new CreateIndexChange();
        refactoring.setIndexName("IDX_TEST");
        refactoring.setTableName("TAB_NAME");
        AddColumnConfig column1 = new AddColumnConfig();
        column1.setName("COL1");
        refactoring.addColumn(column1);
        AddColumnConfig column2 = new AddColumnConfig();
        column2.setName("COL2");
        column2.setDescending(Boolean.valueOf(true));
        refactoring.addColumn(column2);
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"createIndex", (Object)element.getTagName());
        Assert.assertEquals((Object)"IDX_TEST", (Object)element.getAttribute("indexName"));
        Assert.assertEquals((Object)"TAB_NAME", (Object)element.getAttribute("tableName"));
        Assert.assertEquals((long)2L, (long)element.getChildNodes().getLength());
        Assert.assertEquals((Object)"column", (Object)((Element)element.getChildNodes().item(0)).getTagName());
        Assert.assertEquals((Object)"COL1", (Object)((Element)element.getChildNodes().item(0)).getAttribute("name"));
        Assert.assertEquals((Object)"column", (Object)((Element)element.getChildNodes().item(1)).getTagName());
        Assert.assertEquals((Object)"COL2", (Object)((Element)element.getChildNodes().item(1)).getAttribute("name"));
        Assert.assertEquals((Object)"true", (Object)((Element)element.getChildNodes().item(1)).getAttribute("descending"));
    }

    @Test
    public void createNode_CreateProcedureChange() throws Exception {
        CreateProcedureChange refactoring = new CreateProcedureChange();
        refactoring.setProcedureText("CREATE PROC PROCBODY HERE");
        refactoring.setComments("Comments go here");
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"createProcedure", (Object)element.getTagName());
        Assert.assertEquals((Object)"CREATE PROC PROCBODY HERE", (Object)element.getTextContent());
    }

    @Test
    public void createNode_CreateSequenceChange() throws Exception {
        CreateSequenceChange change = new CreateSequenceChange();
        change.setSequenceName("SEQ_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"createSequence", (Object)node.getNodeName());
        Assert.assertEquals((Object)"SEQ_NAME", (Object)node.getAttribute("sequenceName"));
        Assert.assertFalse((boolean)node.hasAttribute("incrementBy"));
        Assert.assertFalse((boolean)node.hasAttribute("maxValue"));
        Assert.assertFalse((boolean)node.hasAttribute("minValue"));
        Assert.assertFalse((boolean)node.hasAttribute("ordered"));
        Assert.assertFalse((boolean)node.hasAttribute("startValue"));
        Assert.assertFalse((boolean)node.hasAttribute("cycle"));
        change.setIncrementBy(new BigInteger("1"));
        change.setMaxValue(new BigInteger("2"));
        change.setMinValue(new BigInteger("3"));
        change.setOrdered(Boolean.valueOf(true));
        change.setStartValue(new BigInteger("4"));
        change.setCycle(Boolean.valueOf(true));
        node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"createSequence", (Object)node.getNodeName());
        Assert.assertEquals((Object)"SEQ_NAME", (Object)node.getAttribute("sequenceName"));
        Assert.assertEquals((Object)"1", (Object)node.getAttribute("incrementBy"));
        Assert.assertEquals((Object)"2", (Object)node.getAttribute("maxValue"));
        Assert.assertEquals((Object)"3", (Object)node.getAttribute("minValue"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("ordered"));
        Assert.assertEquals((Object)"4", (Object)node.getAttribute("startValue"));
        Assert.assertEquals((Object)"true", (Object)node.getAttribute("cycle"));
    }

    @Test
    public void createNode_CreateTableChange() throws Exception {
        CreateTableChange change = new CreateTableChange();
        change.setTableName("TABLE_NAME");
        ColumnConfig column1 = new ColumnConfig();
        column1.setName("id");
        column1.setType("int");
        ConstraintsConfig column1constraints = new ConstraintsConfig();
        column1constraints.setPrimaryKey(Boolean.valueOf(true));
        column1constraints.setNullable(Boolean.valueOf(false));
        column1.setConstraints(column1constraints);
        change.addColumn(column1);
        ColumnConfig column2 = new ColumnConfig();
        column2.setName("name");
        column2.setType("varchar(255)");
        change.addColumn(column2);
        ColumnConfig column3 = new ColumnConfig();
        column3.setName("state_id");
        ConstraintsConfig column3constraints = new ConstraintsConfig();
        column3constraints.setNullable(Boolean.valueOf(false));
        column3constraints.setInitiallyDeferred(Boolean.valueOf(true));
        column3constraints.setDeferrable(Boolean.valueOf(true));
        column3constraints.setForeignKeyName("fk_tab_ref");
        column3constraints.setReferences("state(id)");
        column3.setConstraints(column3constraints);
        change.addColumn(column3);
        ColumnConfig column4 = new ColumnConfig();
        column4.setName("phone");
        column4.setType("varchar(255)");
        column4.setDefaultValue("NOPHONE");
        change.addColumn(column4);
        ColumnConfig column5 = new ColumnConfig();
        column5.setName("phone2");
        column5.setType("varchar(255)");
        ConstraintsConfig column5constraints = new ConstraintsConfig();
        column5constraints.setUnique(Boolean.valueOf(true));
        column5.setConstraints(column5constraints);
        change.addColumn(column5);
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"createTable", (Object)element.getTagName());
        Assert.assertEquals((long)5L, (long)element.getChildNodes().getLength());
        Element columnElement = (Element)element.getChildNodes().item(0);
        Assert.assertEquals((Object)"column", (Object)columnElement.getTagName());
        Assert.assertEquals((Object)"id", (Object)columnElement.getAttribute("name"));
        Assert.assertEquals((Object)"int", (Object)columnElement.getAttribute("type"));
        Element constraintsElement = (Element)columnElement.getChildNodes().item(0);
        Assert.assertEquals((Object)"constraints", (Object)constraintsElement.getTagName());
        Assert.assertEquals((long)2L, (long)constraintsElement.getAttributes().getLength());
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("primaryKey"));
        Assert.assertEquals((Object)"false", (Object)constraintsElement.getAttribute("nullable"));
        columnElement = (Element)element.getChildNodes().item(1);
        Assert.assertEquals((Object)"column", (Object)columnElement.getTagName());
        Assert.assertEquals((Object)"name", (Object)columnElement.getAttribute("name"));
        Assert.assertEquals((Object)"varchar(255)", (Object)columnElement.getAttribute("type"));
        columnElement = (Element)element.getChildNodes().item(2);
        Assert.assertEquals((Object)"column", (Object)columnElement.getTagName());
        Assert.assertEquals((Object)"state_id", (Object)columnElement.getAttribute("name"));
        constraintsElement = (Element)columnElement.getChildNodes().item(0);
        Assert.assertEquals((Object)"constraints", (Object)constraintsElement.getTagName());
        Assert.assertEquals((long)5L, (long)constraintsElement.getAttributes().getLength());
        Assert.assertEquals((Object)"false", (Object)constraintsElement.getAttribute("nullable"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("deferrable"));
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("initiallyDeferred"));
        Assert.assertEquals((Object)"fk_tab_ref", (Object)constraintsElement.getAttribute("foreignKeyName"));
        Assert.assertEquals((Object)"state(id)", (Object)constraintsElement.getAttribute("references"));
        columnElement = (Element)element.getChildNodes().item(3);
        Assert.assertEquals((Object)"column", (Object)columnElement.getTagName());
        Assert.assertEquals((Object)"phone", (Object)columnElement.getAttribute("name"));
        Assert.assertEquals((Object)"varchar(255)", (Object)columnElement.getAttribute("type"));
        columnElement = (Element)element.getChildNodes().item(4);
        Assert.assertEquals((Object)"column", (Object)columnElement.getTagName());
        Assert.assertEquals((Object)"phone2", (Object)columnElement.getAttribute("name"));
        Assert.assertEquals((Object)"varchar(255)", (Object)columnElement.getAttribute("type"));
        constraintsElement = (Element)columnElement.getChildNodes().item(0);
        Assert.assertEquals((Object)"constraints", (Object)constraintsElement.getTagName());
        Assert.assertEquals((long)1L, (long)constraintsElement.getAttributes().getLength());
        Assert.assertEquals((Object)"true", (Object)constraintsElement.getAttribute("unique"));
    }

    @Test
    public void createNodeDropColumnChange() throws Exception {
        DropColumnChange change = new DropColumnChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropColumn", (Object)node.getTagName());
        Assert.assertFalse((boolean)node.hasAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"COL_NAME", (Object)node.getAttribute("columnName"));
    }

    @Test
    public void createNode_DropColumnChange_withSchema() throws Exception {
        DropColumnChange change = new DropColumnChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropColumn", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"COL_NAME", (Object)node.getAttribute("columnName"));
    }

    @Test
    public void createNode_DropDefaultValueChange() throws Exception {
        DropDefaultValueChange change = new DropDefaultValueChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropDefaultValue", (Object)node.getTagName());
        Assert.assertFalse((boolean)node.hasAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"COL_NAME", (Object)node.getAttribute("columnName"));
    }

    @Test
    public void createNode_DropDefaultValueChange_withSchema() throws Exception {
        DropDefaultValueChange change = new DropDefaultValueChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropDefaultValue", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"COL_NAME", (Object)node.getAttribute("columnName"));
    }

    @Test
    public void createNode_DropForeignKeyConstraintChange() throws Exception {
        DropForeignKeyConstraintChange change = new DropForeignKeyConstraintChange();
        change.setBaseTableSchemaName("SCHEMA_NAME");
        change.setBaseTableName("TABLE_NAME");
        change.setConstraintName("FK_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropForeignKeyConstraint", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("baseTableSchemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("baseTableName"));
        Assert.assertEquals((Object)"FK_NAME", (Object)node.getAttribute("constraintName"));
    }

    @Test
    public void createNode_DropIndexChange() throws Exception {
        DropIndexChange refactoring = new DropIndexChange();
        refactoring.setIndexName("IDX_NAME");
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"dropIndex", (Object)element.getTagName());
        Assert.assertEquals((Object)"IDX_NAME", (Object)element.getAttribute("indexName"));
    }

    @Test
    public void createNode_DropNotNullConstraintChange() throws Exception {
        DropNotNullConstraintChange change = new DropNotNullConstraintChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_HERE");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropNotNullConstraint", (Object)node.getTagName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"COL_HERE", (Object)node.getAttribute("columnName"));
    }

    @Test
    public void createNode_DropPrimaryKeyChange() throws Exception {
        DropPrimaryKeyChange change = new DropPrimaryKeyChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setConstraintName("PK_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropPrimaryKey", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"PK_NAME", (Object)node.getAttribute("constraintName"));
    }

    @Test
    public void createNode_DropSequenceChange() throws Exception {
        DropSequenceChange change = new DropSequenceChange();
        change.setSequenceName("SEQ_NAME");
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropSequence", (Object)element.getTagName());
        Assert.assertEquals((Object)"SEQ_NAME", (Object)element.getAttribute("sequenceName"));
    }

    @Test
    public void createNode_DropTableChange() throws Exception {
        DropTableChange change = new DropTableChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TAB_NAME");
        change.setCascadeConstraints(Boolean.valueOf(true));
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropTable", (Object)element.getTagName());
        Assert.assertEquals((Object)"TAB_NAME", (Object)element.getAttribute("tableName"));
        Assert.assertEquals((Object)"true", (Object)element.getAttribute("cascadeConstraints"));
    }

    @Test
    public void createNode_DropTableChange_withSchema() throws Exception {
        DropTableChange change = new DropTableChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TAB_NAME");
        change.setCascadeConstraints(Boolean.valueOf(true));
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropTable", (Object)element.getTagName());
        Assert.assertEquals((Object)"TAB_NAME", (Object)element.getAttribute("tableName"));
        Assert.assertEquals((Object)"true", (Object)element.getAttribute("cascadeConstraints"));
        Assert.assertTrue((boolean)element.hasAttribute("schemaName"));
    }

    @Test
    public void createNode_nullConstraint() throws Exception {
        DropTableChange change = new DropTableChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TAB_NAME");
        change.setCascadeConstraints(null);
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropTable", (Object)element.getTagName());
        Assert.assertFalse((boolean)element.hasAttribute("cascadeConstraints"));
    }

    @Test
    public void createNode_DropUniqueConstraintChange() throws Exception {
        DropUniqueConstraintChange change = new DropUniqueConstraintChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TAB_NAME");
        change.setConstraintName("UQ_CONSTRAINT");
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropUniqueConstraint", (Object)element.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)element.getAttribute("schemaName"));
        Assert.assertEquals((Object)"TAB_NAME", (Object)element.getAttribute("tableName"));
        Assert.assertEquals((Object)"UQ_CONSTRAINT", (Object)element.getAttribute("constraintName"));
    }

    @Test
    public void createNode_DropUniqueConstraintChange_noSchema() throws Exception {
        DropUniqueConstraintChange change = new DropUniqueConstraintChange();
        change.setTableName("TAB_NAME");
        change.setConstraintName("UQ_CONSTRAINT");
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropUniqueConstraint", (Object)element.getTagName());
        Assert.assertEquals((Object)"TAB_NAME", (Object)element.getAttribute("tableName"));
        Assert.assertEquals((Object)"UQ_CONSTRAINT", (Object)element.getAttribute("constraintName"));
        Assert.assertFalse((boolean)element.hasAttribute("schemaName"));
    }

    @Test
    public void createNode_DropViewChange() throws Exception {
        DropViewChange change = new DropViewChange();
        change.setViewName("VIEW_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropView", (Object)node.getTagName());
        Assert.assertFalse((boolean)node.hasAttribute("schemaName"));
        Assert.assertEquals((Object)"VIEW_NAME", (Object)node.getAttribute("viewName"));
    }

    @Test
    public void createNode_DropViewChange_withSchema() throws Exception {
        DropViewChange change = new DropViewChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setViewName("VIEW_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"dropView", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"VIEW_NAME", (Object)node.getAttribute("viewName"));
    }

    @Test
    public void createNode_InsertDataChange() throws Exception {
        InsertDataChange refactoring = new InsertDataChange();
        refactoring.setTableName("TABLE_NAME");
        ColumnConfig col1 = new ColumnConfig();
        col1.setName("id");
        col1.setValueNumeric("123");
        ColumnConfig col2 = new ColumnConfig();
        col2.setName("name");
        col2.setValue("Andrew");
        ColumnConfig col3 = new ColumnConfig();
        col3.setName("age");
        col3.setValueNumeric("21");
        ColumnConfig col4 = new ColumnConfig();
        col4.setName("height");
        col4.setValueNumeric("1.78");
        refactoring.addColumn(col1);
        refactoring.addColumn(col2);
        refactoring.addColumn(col3);
        refactoring.addColumn(col4);
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"insert", (Object)node.getTagName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        NodeList columns = node.getChildNodes();
        Assert.assertEquals((long)4L, (long)columns.getLength());
        Assert.assertEquals((Object)"column", (Object)((Element)columns.item(0)).getTagName());
        Assert.assertEquals((Object)"id", (Object)((Element)columns.item(0)).getAttribute("name"));
        Assert.assertEquals((Object)"123", (Object)((Element)columns.item(0)).getAttribute("valueNumeric"));
        Assert.assertEquals((Object)"column", (Object)((Element)columns.item(1)).getTagName());
        Assert.assertEquals((Object)"name", (Object)((Element)columns.item(1)).getAttribute("name"));
        Assert.assertEquals((Object)"Andrew", (Object)((Element)columns.item(1)).getAttribute("value"));
        Assert.assertEquals((Object)"column", (Object)((Element)columns.item(2)).getTagName());
        Assert.assertEquals((Object)"age", (Object)((Element)columns.item(2)).getAttribute("name"));
        Assert.assertEquals((Object)"21", (Object)((Element)columns.item(2)).getAttribute("valueNumeric"));
        Assert.assertEquals((Object)"column", (Object)((Element)columns.item(3)).getTagName());
        Assert.assertEquals((Object)"height", (Object)((Element)columns.item(3)).getAttribute("name"));
        Assert.assertEquals((Object)"1.78", (Object)((Element)columns.item(3)).getAttribute("valueNumeric"));
    }

    @Test
    public void createNode_LoadDataChange() throws Exception {
        LoadDataChange refactoring = new LoadDataChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("FILE_NAME");
        refactoring.setEncoding(StandardCharsets.UTF_8.name());
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"loadData", (Object)node.getNodeName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"FILE_NAME", (Object)node.getAttribute("file"));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)node.getAttribute("encoding"));
    }

    @Test
    public void createNode_RawSQLChange() throws Exception {
        RawSQLChange refactoring = new RawSQLChange();
        refactoring.setSql("SOME SQL HERE");
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"sql", (Object)element.getTagName());
        Assert.assertEquals((Object)"SOME SQL HERE", (Object)element.getTextContent());
    }

    @Test
    public void createNode_RenameColumnChange() throws Exception {
        RenameColumnChange refactoring = new RenameColumnChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setOldColumnName("oldColName");
        refactoring.setNewColumnName("newColName");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"renameColumn", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"TABLE_NAME", (Object)node.getAttribute("tableName"));
        Assert.assertEquals((Object)"oldColName", (Object)node.getAttribute("oldColumnName"));
        Assert.assertEquals((Object)"newColName", (Object)node.getAttribute("newColumnName"));
    }

    @Test
    public void createNode_RenameTableChange() throws Exception {
        RenameTableChange refactoring = new RenameTableChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setOldTableName("OLD_NAME");
        refactoring.setNewTableName("NEW_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"renameTable", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"OLD_NAME", (Object)node.getAttribute("oldTableName"));
        Assert.assertEquals((Object)"NEW_NAME", (Object)node.getAttribute("newTableName"));
    }

    @Test
    public void createNode_RenameSequenceChange() throws Exception {
        RenameSequenceChange refactoring = new RenameSequenceChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setOldSequenceName("OLD_NAME");
        refactoring.setNewSequenceName("NEW_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"renameSequence", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"OLD_NAME", (Object)node.getAttribute("oldSequenceName"));
        Assert.assertEquals((Object)"NEW_NAME", (Object)node.getAttribute("newSequenceName"));
    }

    @Test
    public void createNode_RenameViewChange() throws Exception {
        RenameViewChange refactoring = new RenameViewChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setOldViewName("OLD_NAME");
        refactoring.setNewViewName("NEW_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"renameView", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"OLD_NAME", (Object)node.getAttribute("oldViewName"));
        Assert.assertEquals((Object)"NEW_NAME", (Object)node.getAttribute("newViewName"));
    }

    @Test
    public void createNode_SQLFileChange() throws Exception {
        String fileName = "liquibase/change/core/SQLFileTestData.sql";
        SQLFileChange change = new SQLFileChange();
        ClassLoaderResourceAccessor opener = new ClassLoaderResourceAccessor();
        change.setPath(fileName);
        Element element = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"sqlFile", (Object)element.getTagName());
        Assert.assertEquals((Object)fileName, (Object)element.getAttribute("path"));
    }

    @Test
    public void createNode_TagDatabaseChange() throws Exception {
        TagDatabaseChange refactoring = new TagDatabaseChange();
        refactoring.setTag("TAG_NAME");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)refactoring);
        Assert.assertEquals((Object)"tagDatabase", (Object)node.getTagName());
        Assert.assertEquals((Object)"TAG_NAME", (Object)node.getAttribute("tag"));
    }

    @Test
    public void createNode_CreateViewChange() throws Exception {
        CreateViewChange change = new CreateViewChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setViewName("VIEW_NAME");
        change.setSelectQuery("SELECT * FROM EXISTING_TABLE");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((Object)"createView", (Object)node.getTagName());
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)node.getAttribute("schemaName"));
        Assert.assertEquals((Object)"VIEW_NAME", (Object)node.getAttribute("viewName"));
        Assert.assertEquals((Object)"SELECT * FROM EXISTING_TABLE", (Object)node.getTextContent());
    }

    @Test
    public void createNode_CustomChange() throws Exception {
        CustomChangeWrapper change = new CustomChangeWrapper();
        change.setClass("liquibase.change.custom.ExampleCustomSqlChange");
        change.setParam("tableName", "tab_name");
        change.setParam("columnName", "col_name");
        change.setParam("newValue", "");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)change);
        Assert.assertEquals((String)"element name", (Object)"customChange", (Object)node.getTagName());
        Assert.assertEquals((String)"customChange attributes", XMLChangeLogSerializerTest.attsMap("class", "liquibase.change.custom.ExampleCustomSqlChange"), XMLChangeLogSerializerTest.attsMap(node));
        NodeList params = node.getChildNodes();
        Assert.assertEquals((String)"params count", (long)3L, (long)params.getLength());
        Assert.assertEquals((String)"element name", (Object)"param", (Object)params.item(0).getNodeName());
        Assert.assertEquals((String)"param[0] attributes", XMLChangeLogSerializerTest.attsMap("name", "tableName", "value", "tab_name"), XMLChangeLogSerializerTest.attsMap(params.item(0)));
        Assert.assertEquals((String)"element name", (Object)"param", (Object)params.item(1).getNodeName());
        Assert.assertEquals((String)"param[1] attributes", XMLChangeLogSerializerTest.attsMap("name", "columnName", "value", "col_name"), XMLChangeLogSerializerTest.attsMap(params.item(1)));
        Assert.assertEquals((String)"element name", (Object)"param", (Object)params.item(2).getNodeName());
        Assert.assertEquals((String)"param[2] attributes", XMLChangeLogSerializerTest.attsMap("name", "newValue", "value", ""), XMLChangeLogSerializerTest.attsMap(params.item(2)));
    }

    @Test
    public void createNode_CustomPrecondition() throws Exception {
        CustomPreconditionWrapper precondition = new CustomPreconditionWrapper();
        precondition.setClassName("liquibase.precondition.ExampleCustomPrecondition");
        precondition.setParam("name", "test_1");
        precondition.setParam("count", "31");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)precondition);
        Assert.assertEquals((String)"element name", (Object)"customPrecondition", (Object)node.getTagName());
        Assert.assertEquals((String)"customPrecondition attributes", XMLChangeLogSerializerTest.attsMap("className", "liquibase.precondition.ExampleCustomPrecondition"), XMLChangeLogSerializerTest.attsMap(node));
        NodeList params = node.getChildNodes();
        Assert.assertEquals((String)"params count", (long)2L, (long)params.getLength());
        Assert.assertEquals((String)"element name", (Object)"param", (Object)params.item(0).getNodeName());
        Assert.assertEquals((String)"param[0] attributes", XMLChangeLogSerializerTest.attsMap("name", "name", "value", "test_1"), XMLChangeLogSerializerTest.attsMap(params.item(0)));
        Assert.assertEquals((String)"element name", (Object)"param", (Object)params.item(1).getNodeName());
        Assert.assertEquals((String)"param[1] attributes", XMLChangeLogSerializerTest.attsMap("name", "count", "value", "31"), XMLChangeLogSerializerTest.attsMap(params.item(1)));
    }

    @Test
    public void createNode_ChangeSetParameters() throws Exception {
        ChangeSet changeSet = new ChangeSet("1", "tms", true, true, "path/to/file.json", "context", "mssql", null, null, false, ObjectQuotingStrategy.LEGACY, null);
        changeSet.setCreated("created");
        changeSet.setFailOnError(Boolean.valueOf(true));
        changeSet.setLabels(new Labels("label"));
        changeSet.setLogicalFilePath("path/to/file.json");
        Element node = new XMLChangeLogSerializer(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()).createNode((LiquibaseSerializable)changeSet);
        Assert.assertEquals((String)"element name", (Object)"changeSet", (Object)node.getTagName());
        Assert.assertEquals((String)"changeSet Attributes", XMLChangeLogSerializerTest.attsMap("id", "1", "author", "tms", "runAlways", "true", "runOnChange", "true", "logicalFilePath", "path/to/file.json", "contextFilter", "context", "dbms", "mssql", "objectQuotingStrategy", "LEGACY", "failOnError", "true", "labels", "label", "created", "created", "runInTransaction", "false"), XMLChangeLogSerializerTest.attsMap(node));
    }

    @Test
    public void serialize_pretty() {
        UpdateDataChange change = new UpdateDataChange();
        change.setCatalogName("a");
        change.setSchemaName("b");
        change.setTableName("c");
        change.setWhere("Some Text");
        String out = new XMLChangeLogSerializer().serialize((LiquibaseSerializable)change, true);
        Assert.assertEquals((Object)"<update catalogName=\"a\"\n        schemaName=\"b\"\n        tableName=\"c\">\n    <where>Some Text</where>\n</update>", (Object)out);
    }

    @Test
    public void serialize_pretty_ChangeSetParameters() throws Exception {
        ChangeSet changeSet = new ChangeSet("1", "tms", true, true, "path/to/file.json", "context", "mssql", "runWith", "runWithSpoolFile", false, ObjectQuotingStrategy.LEGACY, null);
        changeSet.setCreated("created");
        changeSet.setFailOnError(Boolean.valueOf(true));
        changeSet.setLabels(new Labels("label"));
        changeSet.setLogicalFilePath("path/to/file.json");
        changeSet.setIgnore(true);
        changeSet.setRunOrder("last");
        String out = new XMLChangeLogSerializer().serialize((LiquibaseSerializable)changeSet, true);
        Assert.assertEquals((Object)"<changeSet author=\"tms\"\n        contextFilter=\"context\"\n        created=\"created\"\n        dbms=\"mssql\"\n        failOnError=\"true\"\n        id=\"1\"\n        ignore=\"true\"\n        labels=\"label\"\n        logicalFilePath=\"path/to/file.json\"\n        objectQuotingStrategy=\"LEGACY\"\n        runAlways=\"true\"\n        runInTransaction=\"false\"\n        runOnChange=\"true\"\n        runOrder=\"last\"/>", (Object)out);
    }

    @Test
    public void serialize_pretty_nestedNodeWithAttributes() {
        CreateTableChange change = new CreateTableChange();
        change.setCatalogName("a");
        change.setSchemaName("b");
        change.setTableName("c");
        change.addColumn(new ColumnConfig().setName("x").setDefaultValue("x1"));
        change.addColumn(new ColumnConfig().setName("y").setDefaultValue("y1"));
        String out = new XMLChangeLogSerializer().serialize((LiquibaseSerializable)change, true);
        Assert.assertEquals((Object)"<createTable catalogName=\"a\"\n        schemaName=\"b\"\n        tableName=\"c\">\n    <column defaultValue=\"x1\" name=\"x\"/>\n    <column defaultValue=\"y1\" name=\"y\"/>\n</createTable>", (Object)out);
    }

    @Test
    public void serialize_pretty_justAttributes() {
        AddAutoIncrementChange change = new AddAutoIncrementChange();
        change.setCatalogName("a");
        change.setSchemaName("b");
        change.setTableName("c");
        String out = new XMLChangeLogSerializer().serialize((LiquibaseSerializable)change, true);
        Assert.assertEquals((Object)"<addAutoIncrement catalogName=\"a\"\n        schemaName=\"b\"\n        tableName=\"c\"/>", (Object)out);
    }

    private static Map<String, String> attsMap(String ... values) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < values.length; i += 2) {
            map.put(values[i], values[i + 1]);
        }
        return map;
    }

    private static Map<String, String> attsMap(Node elem) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        NamedNodeMap attributes = elem.getAttributes();
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            Node item = attributes.item(i);
            map.put(item.getNodeName(), item.getNodeValue());
        }
        return map;
    }
}

