/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.servicelocator.LiquibaseService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorChain;
import liquibase.structure.DatabaseObject;

public class MockDatabaseSnapshot
extends DatabaseSnapshot {
    private final List<DatabaseObject> configuredObjects;

    public MockDatabaseSnapshot(List<DatabaseObject> configuredObjects, DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        super(null, database, snapshotControl);
        this.configuredObjects = configuredObjects;
        this.init(examples);
    }

    protected SnapshotGeneratorChain createGeneratorChain(Class<? extends DatabaseObject> databaseObjectType, Database database) {
        return new SnapshotGeneratorChain(new TreeSet<MockSnapshotGenerator>(Arrays.asList(new MockSnapshotGenerator())));
    }

    @LiquibaseService(skip=true)
    private class MockSnapshotGenerator
    implements SnapshotGenerator,
    Comparable<SnapshotGenerator> {
        private MockSnapshotGenerator() {
        }

        public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
            return 1;
        }

        public <T extends DatabaseObject> T snapshot(T example, DatabaseSnapshot snapshot, SnapshotGeneratorChain chain) throws DatabaseException, InvalidExampleException {
            for (DatabaseObject object : MockDatabaseSnapshot.this.configuredObjects) {
                if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(object, example, null, MockDatabaseSnapshot.this.getDatabase())) continue;
                return (T)object;
            }
            return null;
        }

        @Override
        public int compareTo(SnapshotGenerator o) {
            return this.toString().compareTo(o.toString());
        }

        public Class<? extends DatabaseObject>[] addsTo() {
            return null;
        }

        public Class<? extends SnapshotGenerator>[] replaces() {
            return null;
        }
    }
}

