/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.MockDatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Relation;

public class MockSnapshotGeneratorFactory
extends SnapshotGeneratorFactory {
    private List<DatabaseObject> objects = new ArrayList<DatabaseObject>();

    public MockSnapshotGeneratorFactory(DatabaseObject ... objects) {
        this.addObjects(objects);
    }

    public DatabaseSnapshot createSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        return new MockDatabaseSnapshot(this.objects, examples, database, snapshotControl);
    }

    public void addObjects(DatabaseObject ... objects) {
        if (objects != null) {
            for (DatabaseObject object : objects) {
                this.objects.add(object);
                if (!(object instanceof Relation)) continue;
                for (Column column : ((Relation)object).getColumns()) {
                    this.objects.add((DatabaseObject)column);
                }
                this.objects.add((DatabaseObject)object.getSchema());
            }
        }
    }

    public void removeObjects(DatabaseObject ... objects) {
        for (DatabaseObject object : objects) {
            this.objects.remove(object);
            if (!(object instanceof Relation)) continue;
            for (Column column : ((Relation)object).getColumns()) {
                this.objects.remove(column);
            }
        }
    }
}

