/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator;

import java.sql.SQLException;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.sqlgenerator.MockSqlGeneratorChain;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateTableStatement;
import liquibase.test.TestContext;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSqlGeneratorTest<T extends SqlStatement> {
    protected SqlGenerator<T> generatorUnderTest;

    public AbstractSqlGeneratorTest(SqlGenerator<T> generatorUnderTest) throws Exception {
        this.generatorUnderTest = generatorUnderTest;
    }

    protected abstract T createSampleSqlStatement();

    protected void dropAndCreateTable(CreateTableStatement statement, Database database) throws SQLException, DatabaseException {
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).execute((SqlStatement)statement);
        if (!database.getAutoCommitMode()) {
            database.getConnection().commit();
        }
    }

    @Test
    public void isImplementation() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            boolean isImpl = this.generatorUnderTest.supports(this.createSampleSqlStatement(), database);
            if (this.shouldBeImplementation(database)) {
                Assert.assertTrue((String)("Unexpected false supports for " + database.getShortName()), (boolean)isImpl);
                continue;
            }
            Assert.assertFalse((String)("Unexpected true supports for " + database.getShortName()), (boolean)isImpl);
        }
    }

    @Test
    public void isValid() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!this.shouldBeImplementation(database)) continue;
            if (this.waitForException(database)) {
                Assert.assertTrue((String)("The validation should be failed for " + database), (boolean)this.generatorUnderTest.validate(this.createSampleSqlStatement(), database, (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
                continue;
            }
            Assert.assertFalse((String)("isValid failed against " + database), (boolean)this.generatorUnderTest.validate(this.createSampleSqlStatement(), database, (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        }
    }

    @Test
    public void checkExpectedGenerator() {
        Assert.assertEquals((Object)this.getClass().getName().replaceFirst("Test$", ""), (Object)this.generatorUnderTest.getClass().getName());
    }

    protected boolean waitForException(Database database) {
        return false;
    }

    protected boolean shouldBeImplementation(Database database) {
        return true;
    }
}

