/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

@LiquibaseService(skip=true)
public class MockSqlGenerator
implements SqlGenerator {
    private int priority;
    private boolean supports;
    private ValidationErrors errors = new ValidationErrors();
    private String[] returnSql;

    public MockSqlGenerator(int priority, String ... returnSql) {
        this(priority, true, returnSql);
    }

    public MockSqlGenerator(int priority, boolean supports, String ... returnSql) {
        this.priority = priority;
        this.supports = supports;
        this.returnSql = returnSql;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean supports(SqlStatement statement, Database database) {
        return this.supports;
    }

    public boolean generateStatementsIsVolatile(Database database) {
        return false;
    }

    public boolean generateRollbackStatementsIsVolatile(Database database) {
        return false;
    }

    public MockSqlGenerator addValidationError(String message) {
        this.errors.addError(message);
        return this;
    }

    public Warnings warn(SqlStatement sqlStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new Warnings();
    }

    public ValidationErrors validate(SqlStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = sqlGeneratorChain.validate(statement, database);
        validationErrors.addAll(this.errors);
        return validationErrors;
    }

    public Sql[] generateSql(SqlStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<Object> sql = new ArrayList<Object>();
        for (String returnSql : this.returnSql) {
            sql.add(new UnparsedSql(returnSql, new DatabaseObject[0]));
        }
        sql.addAll(Arrays.asList(sqlGeneratorChain.generateSql(statement, database)));
        return sql.toArray(EMPTY_SQL);
    }
}

