/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator;

import java.util.Collection;
import java.util.SortedSet;
import liquibase.database.Database;
import liquibase.database.core.H2Database;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sqlgenerator.MockSqlGenerator;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AddAutoIncrementGenerator;
import liquibase.sqlgenerator.core.AddAutoIncrementGeneratorDB2;
import liquibase.sqlgenerator.core.AddAutoIncrementGeneratorHsqlH2;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddAutoIncrementStatement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlGeneratorFactoryTest {
    private AddAutoIncrementStatement statement;
    private H2Database database;
    private SqlGeneratorFactory factory;

    @Before
    public void setUp() {
        this.statement = new AddAutoIncrementStatement(null, null, "person", "name", "varchar(255)", null, null, null, null);
        this.database = new H2Database();
        this.factory = SqlGeneratorFactory.getInstance();
    }

    @After
    public void teardown() {
        SqlGeneratorFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)SqlGeneratorFactory.getInstance());
        Assert.assertSame((Object)SqlGeneratorFactory.getInstance(), (Object)SqlGeneratorFactory.getInstance());
    }

    @Test
    public void register() {
        this.factory.getGenerators().clear();
        Assert.assertEquals((long)0L, (long)this.factory.getGenerators().size());
        this.factory.register((SqlGenerator)new MockSqlGenerator(1, "A1"));
        Assert.assertEquals((long)1L, (long)this.factory.getGenerators().size());
    }

    @Test
    public void unregisterInstance() {
        this.factory.getGenerators().clear();
        Assert.assertEquals((long)0L, (long)this.factory.getGenerators().size());
        AddAutoIncrementGeneratorHsqlH2 sqlGenerator = new AddAutoIncrementGeneratorHsqlH2();
        this.factory.register((SqlGenerator)new AddAutoIncrementGenerator());
        this.factory.register((SqlGenerator)sqlGenerator);
        this.factory.register((SqlGenerator)new AddAutoIncrementGeneratorDB2());
        Assert.assertEquals((long)3L, (long)this.factory.getGenerators().size());
        this.factory.unregister((SqlGenerator)sqlGenerator);
        Assert.assertEquals((long)2L, (long)this.factory.getGenerators().size());
    }

    @Test
    public void unregisterClass() {
        this.factory.getGenerators().clear();
        Assert.assertEquals((long)0L, (long)this.factory.getGenerators().size());
        AddAutoIncrementGeneratorHsqlH2 sqlGenerator = new AddAutoIncrementGeneratorHsqlH2();
        this.factory.register((SqlGenerator)new AddAutoIncrementGenerator());
        this.factory.register((SqlGenerator)sqlGenerator);
        this.factory.register((SqlGenerator)new AddAutoIncrementGeneratorDB2());
        Assert.assertEquals((long)3L, (long)this.factory.getGenerators().size());
        this.factory.unregister(AddAutoIncrementGeneratorHsqlH2.class);
        Assert.assertEquals((long)2L, (long)this.factory.getGenerators().size());
    }

    @Test
    public void unregisterClassDoesNotExist() {
        this.factory.getGenerators().clear();
        Assert.assertEquals((long)0L, (long)this.factory.getGenerators().size());
        this.factory.register((SqlGenerator)new AddAutoIncrementGenerator());
        this.factory.register((SqlGenerator)new AddAutoIncrementGeneratorHsqlH2());
        this.factory.register((SqlGenerator)new AddAutoIncrementGeneratorDB2());
        Assert.assertEquals((long)3L, (long)this.factory.getGenerators().size());
        this.factory.unregister(AddColumnGenerator.class);
        Assert.assertEquals((long)3L, (long)this.factory.getGenerators().size());
    }

    @Test
    public void unregisterClassWithCache() {
        this.factory.getGenerators().clear();
        Assert.assertEquals((long)0L, (long)this.factory.getGenerators((SqlStatement)this.statement, (Database)this.database).size());
        CustomAddAutoIncrementGeneratorHsqlH2 sqlGenerator = new CustomAddAutoIncrementGeneratorHsqlH2();
        this.factory.register((SqlGenerator)sqlGenerator);
        this.factory.register((SqlGenerator)new AddAutoIncrementGeneratorHsqlH2());
        Assert.assertEquals((long)2L, (long)this.factory.getGenerators((SqlStatement)this.statement, (Database)this.database).size());
        this.factory.unregister(AddAutoIncrementGeneratorHsqlH2.class);
        Assert.assertEquals((long)1L, (long)this.factory.getGenerators((SqlStatement)this.statement, (Database)this.database).size());
    }

    @Test
    public void unregisterClassDoesNotExistWithCache() {
        this.factory.getGenerators().clear();
        Assert.assertEquals((long)0L, (long)this.factory.getGenerators((SqlStatement)this.statement, (Database)this.database).size());
        this.factory.register((SqlGenerator)new CustomAddAutoIncrementGeneratorHsqlH2());
        this.factory.register((SqlGenerator)new AddAutoIncrementGeneratorHsqlH2());
        Assert.assertEquals((long)2L, (long)this.factory.getGenerators((SqlStatement)this.statement, (Database)this.database).size());
        this.factory.unregister(AddColumnGenerator.class);
        Assert.assertEquals((long)2L, (long)this.factory.getGenerators((SqlStatement)this.statement, (Database)this.database).size());
    }

    @Test
    public void reset() {
        SqlGeneratorFactory.reset();
        Assert.assertNotSame((Object)this.factory, (Object)SqlGeneratorFactory.getInstance());
    }

    @Test
    public void builtInGeneratorsAreFound() {
        Collection generators = this.factory.getGenerators();
        Assert.assertTrue((generators.size() > 10 ? 1 : 0) != 0);
    }

    @Test
    public void getGenerators() {
        SortedSet allGenerators = SqlGeneratorFactory.getInstance().getGenerators((SqlStatement)new AddAutoIncrementStatement(null, null, "person", "name", "varchar(255)", null, null, null, null), (Database)new H2Database());
        Assert.assertNotNull((Object)allGenerators);
        Assert.assertEquals((long)1L, (long)allGenerators.size());
    }

    @LiquibaseService(skip=true)
    private class CustomAddAutoIncrementGeneratorHsqlH2
    extends AddAutoIncrementGeneratorHsqlH2 {
        private CustomAddAutoIncrementGeneratorHsqlH2() {
        }

        public int getPriority() {
            return super.getPriority() + 1;
        }
    }
}

