/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.change.AddColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.exception.DatabaseException;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.AbstractSqlGeneratorTest;
import liquibase.sqlgenerator.MockSqlGeneratorChain;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import org.junit.Assert;
import org.junit.Test;

public class AddColumnGeneratorTest
extends AbstractSqlGeneratorTest<AddColumnStatement> {
    private static final String SCHEMA_NAME = "schema_name";
    private static final String CATALOG_NAME = "catalog_name";
    private static final String TABLE_NAME = "table_name";
    private static final String COLUMN_NAME = "column_name";
    private static final String COLUMN_TYPE = "column_type";

    public AddColumnGeneratorTest() throws Exception {
        this((SqlGenerator<AddColumnStatement>)new AddColumnGenerator());
    }

    protected AddColumnGeneratorTest(SqlGenerator<AddColumnStatement> generatorUnderTest) throws Exception {
        super(generatorUnderTest);
    }

    @Override
    protected AddColumnStatement createSampleSqlStatement() {
        return new AddColumnStatement(null, null, TABLE_NAME, COLUMN_NAME, COLUMN_TYPE, null, new ColumnConstraint[0]);
    }

    @Override
    public void isValid() throws Exception {
        super.isValid();
        AddColumnStatement addPKColumn = new AddColumnStatement(null, null, TABLE_NAME, COLUMN_NAME, COLUMN_TYPE, null, new ColumnConstraint[]{new PrimaryKeyConstraint("pk_name")});
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new OracleDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new H2Database(), (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new DB2Database(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a primary key column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new DerbyDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a primary key column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new SQLiteDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a primary key column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)new AddColumnStatement(null, null, null, null, null, null, new ColumnConstraint[]{new AutoIncrementConstraint()}), (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a non-primary key identity column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)new AddColumnStatement(null, null, null, null, null, null, new ColumnConstraint[]{new AutoIncrementConstraint()}), (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a non-primary key identity column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)new AddColumnStatement(new AddColumnStatement[]{new AddColumnStatement(null, null, TABLE_NAME, COLUMN_NAME, COLUMN_TYPE, null, new ColumnConstraint[0]), new AddColumnStatement(null, null, "other_table", "other_column", COLUMN_TYPE, null, new ColumnConstraint[0])}), (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("All columns must be targeted at the same table"));
    }

    @Test
    public void isValidH2Version1() {
        H2Database h2DatabaseV1 = new H2Database(){

            public int getDatabaseMajorVersion() {
                return 1;
            }
        };
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)this.createSampleSqlStatement(), (Database)h2DatabaseV1, (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
    }

    @Test
    public void testAddColumnAfter() {
        AddColumnStatement statement = new AddColumnStatement(null, null, TABLE_NAME, COLUMN_NAME, COLUMN_TYPE, null, new ColumnConstraint[0]);
        statement.setAddAfterColumn("column_after");
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)statement, (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
    }

    @Test
    public void testAddMultipleColumnsMySql() {
        AddColumnStatement columns = new AddColumnStatement(new AddColumnStatement[]{new AddColumnStatement(null, null, TABLE_NAME, "column1", "INT", null, new ColumnConstraint[]{new NotNullConstraint()}), new AddColumnStatement(null, null, TABLE_NAME, "column2", "INT", null, new ColumnConstraint[]{new NotNullConstraint()})});
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)columns, (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Sql[] sql = this.generatorUnderTest.generateSql((SqlStatement)columns, (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assert.assertEquals((long)1L, (long)sql.length);
        Assert.assertEquals((Object)"ALTER TABLE table_name ADD column1 INT NOT NULL, ADD column2 INT NOT NULL", (Object)sql[0].toSql());
        List actualNames = sql[0].getAffectedDatabaseObjects().stream().map(o -> o.toString()).collect(Collectors.toList());
        List<String> expectedNames = Arrays.asList("table_name.column1", "table_name.column2", TABLE_NAME, "DEFAULT");
        Assert.assertTrue((boolean)actualNames.containsAll(expectedNames));
        Assert.assertTrue((boolean)expectedNames.containsAll(actualNames));
    }

    @Test
    public void testAddPeriodColumnMariaDb() {
        AddColumnStatement columns = new AddColumnStatement(null, null, TABLE_NAME, "PERIOD", "INT", null, new ColumnConstraint[]{new NotNullConstraint()});
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)columns, (Database)new MariaDBDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Sql[] sql = this.generatorUnderTest.generateSql((SqlStatement)columns, (Database)new MariaDBDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assert.assertEquals((long)1L, (long)sql.length);
        Assert.assertEquals((Object)"ALTER TABLE table_name ADD `PERIOD` INT NOT NULL", (Object)sql[0].toSql());
    }

    @Test
    public void testAddPrimaryKeyColumnH2() {
        AddColumnStatement columns = new AddColumnStatement(null, null, TABLE_NAME, "ID", "BIGINT", null, new ColumnConstraint[]{new PrimaryKeyConstraint()});
        H2Database h2Database = new H2Database();
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)columns, (Database)h2Database, (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)columns, (Database)new H2Database(){

            public int getDatabaseMajorVersion() throws DatabaseException {
                return 1;
            }
        }, (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Sql[] sql = this.generatorUnderTest.generateSql((SqlStatement)columns, (Database)h2Database, (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assert.assertEquals((long)1L, (long)sql.length);
        Assert.assertEquals((Object)"ALTER TABLE table_name ADD ID BIGINT NOT NULL PRIMARY KEY", (Object)sql[0].toSql());
    }

    @Test
    public void testAddColumnWithNotNullConstraintAndValue() {
        AddColumnChange change = new AddColumnChange();
        change.setTableName(TABLE_NAME);
        change.setSchemaName(SCHEMA_NAME);
        AddColumnConfig column = new AddColumnConfig();
        column.setName("column1");
        column.setType("int8");
        column.setValueNumeric("0");
        column.setConstraints(new ConstraintsConfig().setNullable(Boolean.valueOf(false)));
        change.addColumn(column);
        AddColumnConfig column2 = new AddColumnConfig();
        column2.setName("column2");
        column2.setType("boolean");
        column2.setValueBoolean("true");
        column2.setConstraints(new ConstraintsConfig().setNullable(Boolean.valueOf(false)));
        change.addColumn(column2);
        SqlStatement[] statements = change.generateStatements((Database)new MySQLDatabase());
        SqlGeneratorFactory instance = SqlGeneratorFactory.getInstance();
        Sql[] sql = instance.generateSql(statements, (Database)new MySQLDatabase());
        Assert.assertEquals((long)5L, (long)sql.length);
        Assert.assertEquals((Object)"ALTER TABLE schema_name.table_name ADD column1 BIGINT NULL, ADD column2 BIT(1) NULL", (Object)sql[0].toSql());
        Assert.assertEquals((Object)"UPDATE schema_name.table_name SET column1 = 0", (Object)sql[1].toSql());
        Assert.assertEquals((Object)"UPDATE schema_name.table_name SET column2 = 1", (Object)sql[2].toSql());
        Assert.assertEquals((Object)"ALTER TABLE schema_name.table_name MODIFY column1 BIGINT NOT NULL", (Object)sql[3].toSql());
        Assert.assertEquals((Object)"ALTER TABLE schema_name.table_name MODIFY column2 BIT(1) NOT NULL", (Object)sql[4].toSql());
    }
}

