/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddDefaultValueGeneratorInformix;
import liquibase.statement.core.AddDefaultValueStatement;
import org.junit.Assert;
import org.junit.Test;

public class AddDefaultValueGeneratorInformixTest {
    private AddDefaultValueGeneratorInformix generator = new AddDefaultValueGeneratorInformix();

    @Test
    public void generateSql() {
        AddDefaultValueStatement statement = new AddDefaultValueStatement("catalog1", "schema2", "table3", "column4", "type5", (Object)"default-value-6");
        InformixDatabase database = new InformixDatabase();
        Sql[] sql = this.generator.generateSql(statement, (Database)database, null);
        Assert.assertEquals((long)1L, (long)sql.length);
        Assert.assertEquals((Object)"ALTER TABLE catalog1:schema2.table3 MODIFY (column4 TYPE5 DEFAULT 'default-value-6')", (Object)sql[0].toSql());
    }

    @Test
    public void shouldGenerateINT8TypeForBIGINTAndDefaultValue() throws Exception {
        AddDefaultValueGeneratorInformix informix = new AddDefaultValueGeneratorInformix();
        AddDefaultValueStatement statement = new AddDefaultValueStatement(null, null, "tbl1", "id", "BIGINT", (Object)1);
        InformixDatabase database = new InformixDatabase();
        TreeSet sqlGenerators = new TreeSet();
        SqlGeneratorChain sqlGenerationChain = new SqlGeneratorChain(sqlGenerators);
        Sql[] sqls = informix.generateSql(statement, (Database)database, sqlGenerationChain);
        Assert.assertEquals((Object)"ALTER TABLE tbl1 MODIFY (id INT8 DEFAULT 1)", (Object)sqls[0].toSql());
    }
}

