/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.math.BigInteger;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.AbstractSqlGeneratorTest;
import liquibase.sqlgenerator.core.AlterSequenceGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AlterSequenceStatement;
import liquibase.test.TestContext;
import org.junit.Assert;
import org.junit.Test;

public class AlterSequenceGeneratorTest
extends AbstractSqlGeneratorTest<AlterSequenceStatement> {
    protected static final String SEQUENCE_NAME = "SEQUENCE_NAME";
    protected static final String CATALOG_NAME = "CATALOG_NAME";
    protected static final String SCHEMA_NAME = "SCHEMA_NAME";

    public AlterSequenceGeneratorTest() throws Exception {
        super(new AlterSequenceGenerator());
    }

    @Test
    public void testAlterSequenceDatabase() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof OracleDatabase)) continue;
            AlterSequenceStatement statement = this.createSampleSqlStatement();
            statement.setCacheSize(BigInteger.valueOf(3000L));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"ALTER SEQUENCE CATALOG_NAME.SEQUENCE_NAME CACHE 3000", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAlterSequenceCycleDatabase() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            AlterSequenceStatement statement = this.createSampleSqlStatement();
            statement.setCycle(Boolean.valueOf(false));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            if (database instanceof OracleDatabase) {
                Assert.assertEquals((Object)"ALTER SEQUENCE CATALOG_NAME.SEQUENCE_NAME NOCYCLE", (Object)generatedSql[0].toSql());
                continue;
            }
            if (!(database instanceof PostgresDatabase) && !(database instanceof CockroachDatabase)) continue;
            Assert.assertEquals((Object)"ALTER SEQUENCE SCHEMA_NAME.SEQUENCE_NAME NO CYCLE", (Object)generatedSql[0].toSql());
        }
    }

    @Override
    protected AlterSequenceStatement createSampleSqlStatement() {
        return new AlterSequenceStatement(CATALOG_NAME, SCHEMA_NAME, SEQUENCE_NAME);
    }

    @Override
    protected boolean shouldBeImplementation(Database database) {
        return database.supportsSequences();
    }
}

