/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.change.AddColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.core.CreateIndexGeneratorPostgres;
import liquibase.statement.core.CreateIndexStatement;
import org.junit.Assert;
import org.junit.Test;

public class CreateIndexGeneratorPostgresTest {
    @Test
    public void generateSql_IndexWithDescSorting_Created() {
        CreateIndexStatement statement = CreateIndexGeneratorPostgresTest.newStatement("INDEX1", "CATALOG1", "SCHEMA1", "TABLE1", CreateIndexGeneratorPostgresTest.newAddColumnConfig("COL1", false), CreateIndexGeneratorPostgresTest.newAddColumnConfig("COL2", true));
        Sql[] result = CreateIndexGeneratorPostgresTest.generateSql(statement);
        Assert.assertEquals((Object)"CREATE INDEX INDEX1 ON SCHEMA1.TABLE1(COL1, COL2 DESC)", (Object)result[0].toSql());
    }

    private static CreateIndexStatement newStatement(String indexName, String catalogName, String schemaName, String tableName, AddColumnConfig ... columns) {
        return new CreateIndexStatement(indexName, catalogName, schemaName, tableName, Boolean.valueOf(false), "", columns);
    }

    private static AddColumnConfig newAddColumnConfig(String name, Boolean descending) {
        AddColumnConfig column = new AddColumnConfig();
        column.setName(name);
        column.setDescending(descending);
        return column;
    }

    private static Sql[] generateSql(CreateIndexStatement statement) {
        return new CreateIndexGeneratorPostgres().generateSql(statement, (Database)new PostgresDatabase(), null);
    }
}

