/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.math.BigInteger;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.H2Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sqlgenerator.AbstractSqlGeneratorTest;
import liquibase.sqlgenerator.MockSqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateSequenceGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateSequenceStatement;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class CreateSequenceGeneratorTest
extends AbstractSqlGeneratorTest<CreateSequenceStatement> {
    protected static final String SEQUENCE_NAME = "SEQUENCE_NAME";
    protected static final String CATALOG_NAME = "CATALOG_NAME";
    protected static final String SCHEMA_NAME = "SCHEMA_NAME";

    public CreateSequenceGeneratorTest() throws Exception {
        super(new CreateSequenceGenerator());
    }

    @Override
    protected CreateSequenceStatement createSampleSqlStatement() {
        return new CreateSequenceStatement(CATALOG_NAME, SCHEMA_NAME, SEQUENCE_NAME);
    }

    @Test
    public void postgresDatabaseSupportIfNotExistsByVersion() throws Exception {
        DatabaseConnection dbConnection = (DatabaseConnection)Mockito.mock(DatabaseConnection.class);
        Mockito.when((Object)dbConnection.getDatabaseMajorVersion()).thenReturn((Object)9);
        Mockito.when((Object)dbConnection.getDatabaseMinorVersion()).thenReturn((Object)4);
        PostgresDatabase database = (PostgresDatabase)Mockito.spy((Object)new PostgresDatabase());
        database.setConnection(dbConnection);
        ((PostgresDatabase)Mockito.doReturn((Object)SEQUENCE_NAME).when((Object)database)).escapeSequenceName(CATALOG_NAME, SCHEMA_NAME, SEQUENCE_NAME);
        CreateSequenceStatement createSequenceStatement = this.createSampleSqlStatement();
        createSequenceStatement.setStartValue(new BigInteger("1"));
        Object[] sql = new CreateSequenceGenerator().generateSql(createSequenceStatement, (Database)database, (SqlGeneratorChain)new MockSqlGeneratorChain());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])sql).isNotEmpty()).hasSize(1);
        Assertions.assertThat((String)sql[0].toSql()).doesNotContain(new CharSequence[]{"IF NOT EXISTS"});
        Mockito.reset((Object[])new DatabaseConnection[]{dbConnection});
        Mockito.when((Object)dbConnection.getDatabaseMajorVersion()).thenThrow(DatabaseException.class);
        sql = new CreateSequenceGenerator().generateSql(createSequenceStatement, (Database)database, (SqlGeneratorChain)new MockSqlGeneratorChain());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])sql).isNotEmpty()).hasSize(1);
        Assertions.assertThat((String)sql[0].toSql()).doesNotContain(new CharSequence[]{"IF NOT EXISTS"});
        Mockito.reset((Object[])new DatabaseConnection[]{dbConnection});
        Mockito.when((Object)dbConnection.getDatabaseMajorVersion()).thenReturn((Object)9);
        Mockito.when((Object)dbConnection.getDatabaseMinorVersion()).thenReturn((Object)5);
        sql = new CreateSequenceGenerator().generateSql(createSequenceStatement, (Database)database, (SqlGeneratorChain)new MockSqlGeneratorChain());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])sql).isNotEmpty()).hasSize(1);
        Assertions.assertThat((String)sql[0].toSql()).contains(new CharSequence[]{"IF NOT EXISTS"});
    }

    @Test
    public void postgresDatabaseSupportAsStructureByVersion() throws Exception {
        DatabaseConnection dbConnection = (DatabaseConnection)Mockito.mock(DatabaseConnection.class);
        PostgresDatabase postgresDatabase = (PostgresDatabase)Mockito.spy((Object)new PostgresDatabase());
        postgresDatabase.setConnection(dbConnection);
        ((PostgresDatabase)Mockito.doReturn((Object)SEQUENCE_NAME).when((Object)postgresDatabase)).escapeSequenceName(CATALOG_NAME, SCHEMA_NAME, SEQUENCE_NAME);
        Mockito.when((Object)dbConnection.getDatabaseMajorVersion()).thenReturn((Object)9);
        Mockito.when((Object)dbConnection.getDatabaseMinorVersion()).thenReturn((Object)6);
        CreateSequenceStatement createSequenceStatement = this.createSampleSqlStatement();
        createSequenceStatement.setStartValue(new BigInteger("1"));
        createSequenceStatement.setDataType("int");
        ValidationErrors errors = new CreateSequenceGenerator().validate(createSequenceStatement, (Database)postgresDatabase, (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assertions.assertThat((List)errors.getErrorMessages()).contains((Object[])new String[]{"dataType is not allowed on postgresql"});
        Mockito.reset((Object[])new DatabaseConnection[]{dbConnection});
        Mockito.when((Object)dbConnection.getDatabaseMajorVersion()).thenThrow(DatabaseException.class);
        errors = new CreateSequenceGenerator().validate(createSequenceStatement, (Database)postgresDatabase, (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assertions.assertThat((List)errors.getErrorMessages()).isEmpty();
        Mockito.reset((Object[])new DatabaseConnection[]{dbConnection});
        Mockito.when((Object)dbConnection.getDatabaseMajorVersion()).thenReturn((Object)10);
        Mockito.when((Object)dbConnection.getDatabaseMinorVersion()).thenReturn((Object)0);
        errors = new CreateSequenceGenerator().validate(createSequenceStatement, (Database)postgresDatabase, (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assertions.assertThat((List)errors.getErrorMessages()).isEmpty();
    }

    @Test
    public void oldH2FailsValidationWithDataType() throws Exception {
        DatabaseConnection dbConnection = (DatabaseConnection)Mockito.mock(DatabaseConnection.class);
        H2Database h2Database = new H2Database();
        h2Database.setConnection(dbConnection);
        CreateSequenceStatement stmt = this.createSampleSqlStatement();
        Mockito.when((Object)dbConnection.getDatabaseMajorVersion()).thenReturn((Object)1);
        Mockito.when((Object)dbConnection.getDatabaseMinorVersion()).thenReturn((Object)4);
        stmt.setDataType("BIGINT");
        ValidationErrors errors = this.generatorUnderTest.validate((SqlStatement)stmt, (Database)h2Database, (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assertions.assertThat((List)errors.getErrorMessages()).isEmpty();
        Assertions.assertThat((List)errors.getWarningMessages()).isEmpty();
        stmt.setDataType("INT");
        errors = this.generatorUnderTest.validate((SqlStatement)stmt, (Database)h2Database, (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assertions.assertThat((List)errors.getErrorMessages()).containsExactly((Object[])new String[]{"dataType is not allowed on h2"});
        String sql = this.generatorUnderTest.generateSql((SqlStatement)stmt, (Database)h2Database, (SqlGeneratorChain)new MockSqlGeneratorChain())[0].toSql();
        Assertions.assertThat((String)sql).isEqualTo("CREATE SEQUENCE SCHEMA_NAME.SEQUENCE_NAME");
        Mockito.when((Object)dbConnection.getDatabaseMajorVersion()).thenReturn((Object)2);
        Mockito.when((Object)dbConnection.getDatabaseMinorVersion()).thenReturn((Object)0);
        stmt.setDataType("BIGINT");
        errors = this.generatorUnderTest.validate((SqlStatement)stmt, (Database)h2Database, (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assertions.assertThat((List)errors.getErrorMessages()).isEmpty();
        Assertions.assertThat((List)errors.getWarningMessages()).isEmpty();
        sql = this.generatorUnderTest.generateSql((SqlStatement)stmt, (Database)h2Database, (SqlGeneratorChain)new MockSqlGeneratorChain())[0].toSql();
        Assertions.assertThat((String)sql).isEqualTo("CREATE SEQUENCE SCHEMA_NAME.SEQUENCE_NAME AS BIGINT");
        stmt.setDataType("INT");
        errors = this.generatorUnderTest.validate((SqlStatement)stmt, (Database)h2Database, (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assertions.assertThat((List)errors.getErrorMessages()).isEmpty();
        Assertions.assertThat((List)errors.getWarningMessages()).isEmpty();
        sql = this.generatorUnderTest.generateSql((SqlStatement)stmt, (Database)h2Database, (SqlGeneratorChain)new MockSqlGeneratorChain())[0].toSql();
        Assertions.assertThat((String)sql).isEqualTo("CREATE SEQUENCE SCHEMA_NAME.SEQUENCE_NAME AS INT");
    }

    @Override
    protected boolean shouldBeImplementation(Database database) {
        return database.supportsSequences();
    }
}

