/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.math.BigInteger;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.MockDatabaseConnection;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.IntType;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.AbstractSqlGeneratorTest;
import liquibase.sqlgenerator.core.CreateTableGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.CreateTableStatement;
import liquibase.test.TestContext;
import org.junit.Assert;
import org.junit.Test;

public class CreateTableGeneratorTest
extends AbstractSqlGeneratorTest<CreateTableStatement> {
    protected static final String TABLE_NAME = "TABLE_NAME";
    protected static final String CATALOG_NAME = "CATALOG_NAME";
    protected static final String SCHEMA_NAME = "SCHEMA_NAME";
    protected static final String COLUMN_NAME1 = "COLUMN1_NAME";

    public CreateTableGeneratorTest() throws Exception {
        super(new CreateTableGenerator());
    }

    @Override
    protected CreateTableStatement createSampleSqlStatement() {
        CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
        statement.addColumn(COLUMN_NAME1, (LiquibaseDataType)new IntType());
        return statement;
    }

    @Test
    public void testWithColumnWithDefaultValue() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof OracleDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("java.sql.Types.TIMESTAMP", database), new ColumnConfig().setDefaultValue("null").getDefaultValueObject());
            if (!this.shouldBeImplementation(database)) continue;
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME TIMESTAMP DEFAULT null)", (Object)this.generatorUnderTest.generateSql((SqlStatement)statement, database, null)[0].toSql());
        }
    }

    @Test
    public void testWithColumnSpecificIntType() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("int(11) unsigned", database));
        }
    }

    @Test
    public void testWithDeferredPKs() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("int", database), (Object)new PrimaryKeyConstraint().addColumns(new String[]{COLUMN_NAME1}).setDeferrable(true).setInitiallyDeferred(true));
            if (database.supportsInitiallyDeferrableColumns()) {
                Assert.assertTrue((boolean)this.generatorUnderTest.generateSql((SqlStatement)statement, database, null)[0].toSql().contains("DEFERRABLE"));
                continue;
            }
            Assert.assertFalse((boolean)this.generatorUnderTest.generateSql((SqlStatement)statement, database, null)[0].toSql().contains("DEFERRABLE"));
        }
    }

    @Test
    public void testDefaultValueCurrentTimestampDB2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof AbstractDb2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("datetime", database), (Object)new DatabaseFunction("current_timestamp"));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE \"CATALOG_NAME\".TABLE_NAME (COLUMN1_NAME TIMESTAMP DEFAULT CURRENT TIMESTAMP)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementDB2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof AbstractDb2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE \"CATALOG_NAME\".TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithDB2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof AbstractDb2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE \"CATALOG_NAME\".TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByDB2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof AbstractDb2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE \"CATALOG_NAME\".TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0, INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementDerbyDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof DerbyDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithDerbyDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof DerbyDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByDerbyDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof DerbyDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0, INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementH2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof H2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithH2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof H2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByH2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof H2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0 INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementHsqlDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof HsqlDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithHsqlDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof HsqlDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ONE, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByHsqlDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof HsqlDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ONE, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1 INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementMSSQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MSSQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), new ColumnConstraint[]{new AutoIncrementConstraint(COLUMN_NAME1), new NotNullConstraint(COLUMN_NAME1)});
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((String)("Error on " + database), (Object)"CREATE TABLE CATALOG_NAME.SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME bigint IDENTITY (1, 1) NOT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithMSSQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MSSQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), new ColumnConstraint[]{new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null), new NotNullConstraint(COLUMN_NAME1)});
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME bigint IDENTITY (0, 1) NOT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByMSSQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MSSQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), new ColumnConstraint[]{new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN), new NotNullConstraint(COLUMN_NAME1)});
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME bigint IDENTITY (0, 10) NOT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementMySQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MySQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME BIGINT AUTO_INCREMENT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithMySQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MySQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME BIGINT AUTO_INCREMENT NULL) AUTO_INCREMENT=2", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByMySQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MySQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME BIGINT AUTO_INCREMENT NULL) AUTO_INCREMENT=2", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementPostgresDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!database.getClass().equals(PostgresDatabase.class)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            conn.setDatabaseMajorVersion(9);
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGSERIAL)", (Object)generatedSql[0].toSql());
            conn.setDatabaseMajorVersion(10);
            generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementCockroachDatabase() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!database.getClass().equals(CockroachDatabase.class)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            conn.setDatabaseMajorVersion(9);
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addPrimaryKeyColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), null, "", null, new ColumnConstraint[]{new AutoIncrementConstraint(COLUMN_NAME1)});
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGSERIAL NOT NULL, CONSTRAINT \"TABLE_NAME_pkey\" PRIMARY KEY (COLUMN1_NAME))", (Object)generatedSql[0].toSql());
            conn.setDatabaseMajorVersion(13);
            generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGSERIAL NOT NULL, CONSTRAINT \"TABLE_NAME_pkey\" PRIMARY KEY (COLUMN1_NAME))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementGenerationTypePostgresDatabase() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!database.getClass().equals(PostgresDatabase.class)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            conn.setDatabaseMajorVersion(9);
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            AutoIncrementConstraint constraint = new AutoIncrementConstraint(COLUMN_NAME1);
            constraint.setGenerationType("ALWAYS");
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)constraint);
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGSERIAL)", (Object)generatedSql[0].toSql());
            conn.setDatabaseMajorVersion(10);
            generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED ALWAYS AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithPostgresDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof PostgresDatabase)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            conn.setDatabaseMajorVersion(9);
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGSERIAL)", (Object)generatedSql[0].toSql());
            conn.setDatabaseMajorVersion(10);
            generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByPostgresDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!database.getClass().equals(PostgresDatabase.class)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            conn.setDatabaseMajorVersion(9);
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGSERIAL)", (Object)generatedSql[0].toSql());
            conn.setDatabaseMajorVersion(10);
            generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0, INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementSQLiteDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SQLiteDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT AUTOINCREMENT)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithSQLiteDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SQLiteDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT AUTOINCREMENT)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementBySQLiteDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SQLiteDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT AUTOINCREMENT)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementSybaseASADatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseASADatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT DEFAULT AUTOINCREMENT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithSybaseASADatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseASADatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT DEFAULT AUTOINCREMENT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementBySybaseASADatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseASADatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT DEFAULT AUTOINCREMENT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementSybaseDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((String)("Error with " + database), (Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT IDENTITY NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementSybaseDatabaseWithSpecialCharacters() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, "SCHEMA-NAME", "TABLE NAME");
            statement.addColumn("1ST_COLUMN_NAME", DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint("1ST_COLUMN_NAME"));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((String)("Error with " + database), (Object)"CREATE TABLE [SCHEMA-NAME].[TABLE NAME] ([1ST_COLUMN_NAME] BIGINT IDENTITY NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithSybaseDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT IDENTITY NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementBySybaseDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("BIGINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT IDENTITY NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementOracleDatabase() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof OracleDatabase)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("SMALLINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME NUMBER(5) GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementGenerationTypeOracleDatabase() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof OracleDatabase)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            AutoIncrementConstraint autoIncrementConstraint = new AutoIncrementConstraint(COLUMN_NAME1);
            autoIncrementConstraint.setGenerationType("ALWAYS");
            autoIncrementConstraint.setDefaultOnNull(Boolean.valueOf(true));
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("SMALLINT{autoIncrement:true}", database), (Object)autoIncrementConstraint);
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME NUMBER(5) GENERATED ALWAYS AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementGenerationTypeDefaultOnNullOracleDatabase() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof OracleDatabase)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            AutoIncrementConstraint autoIncrementConstraint = new AutoIncrementConstraint(COLUMN_NAME1);
            autoIncrementConstraint.setGenerationType("BY DEFAULT");
            autoIncrementConstraint.setDefaultOnNull(Boolean.valueOf(true));
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("SMALLINT{autoIncrement:true}", database), (Object)autoIncrementConstraint);
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME NUMBER(5) GENERATED BY DEFAULT ON NULL AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithOracleDatabase() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof OracleDatabase)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("SMALLINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME NUMBER(5) GENERATED BY DEFAULT AS IDENTITY (START WITH 0))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByOracleDatabase() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof OracleDatabase)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("SMALLINT{autoIncrement:true}", database), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE CATALOG_NAME.TABLE_NAME (COLUMN1_NAME NUMBER(5) GENERATED BY DEFAULT AS IDENTITY (START WITH 0, INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void createReferencesSchemaEscaped() throws Exception {
        PostgresDatabase database = new PostgresDatabase();
        database.setOutputDefaultSchema(true);
        database.setDefaultSchemaName("my-schema");
        CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
        statement.addColumnConstraint(new ForeignKeyConstraint("fk_test_parent", "TABLE_NAME(id)").setColumn("id"));
        Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, (Database)database, null);
        Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (, CONSTRAINT fk_test_parent FOREIGN KEY (id) REFERENCES \"my-schema\".TABLE_NAME(id))", (Object)generatedSql[0].toSql());
    }

    @Test
    public void combineUniqueConstraints() {
        SQLiteDatabase database = new SQLiteDatabase();
        database.setOutputDefaultSchema(true);
        LiquibaseDataType integerType = DataTypeFactory.getInstance().fromDescription("INTEGER", (Database)database);
        CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
        statement.addColumn("MY_KEY", integerType, (Object)new UniqueConstraint("SAME"));
        statement.addColumn("MY_OTHER_KEY", integerType, (Object)new UniqueConstraint("SAME"));
        statement.addColumn("SINGLE_UNIQUE_KEY", integerType, (Object)new UniqueConstraint("DIFFERENT"));
        statement.addColumn("UNIQUE_NO_CONSTRAINT_NAME", integerType, (Object)new UniqueConstraint());
        Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, (Database)database, null);
        String expectedSql = "CREATE TABLE CATALOG_NAME.TABLE_NAME (MY_KEY INTEGER, MY_OTHER_KEY INTEGER, SINGLE_UNIQUE_KEY INTEGER, UNIQUE_NO_CONSTRAINT_NAME INTEGER, UNIQUE (UNIQUE_NO_CONSTRAINT_NAME), CONSTRAINT SAME UNIQUE (MY_KEY, MY_OTHER_KEY), CONSTRAINT DIFFERENT UNIQUE (SINGLE_UNIQUE_KEY))";
        Assert.assertEquals((Object)expectedSql, (Object)generatedSql[0].toSql());
    }

    @Test
    public void testGeneratedAlwaysPostgresDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof PostgresDatabase)) continue;
            MockDatabaseConnection conn = new MockDatabaseConnection();
            conn.setDatabaseMajorVersion(9);
            database.setConnection((DatabaseConnection)conn);
            CreateTableStatement statement = new CreateTableStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, DataTypeFactory.getInstance().fromDescription("int", database), new ColumnConfig().setDefaultValue("GENERATED ALWAYS AS (rank_1 / 2) STORED").getDefaultValueObject());
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME INTEGER GENERATED ALWAYS AS (rank_1 / 2) STORED)", (Object)generatedSql[0].toSql());
        }
    }
}

