/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.AbstractSqlGeneratorTest;
import liquibase.sqlgenerator.MockSqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropColumnGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropColumnStatement;
import org.junit.Assert;
import org.junit.Test;

public class DropColumnGeneratorTest
extends AbstractSqlGeneratorTest<DropColumnStatement> {
    public DropColumnGeneratorTest() throws Exception {
        super(new DropColumnGenerator());
    }

    @Override
    protected DropColumnStatement createSampleSqlStatement() {
        return new DropColumnStatement(null, null, "TEST_TABLE", "test_col");
    }

    @Test
    public void testDropMultipleColumnsMySQL() {
        DropColumnStatement drop = new DropColumnStatement(Arrays.asList(new DropColumnStatement(null, null, "TEST_TABLE", "col1"), new DropColumnStatement(null, null, "TEST_TABLE", "col2")));
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)drop, (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Sql[] sql = this.generatorUnderTest.generateSql((SqlStatement)drop, (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assert.assertEquals((long)1L, (long)sql.length);
        Assert.assertEquals((Object)"ALTER TABLE TEST_TABLE DROP col1, DROP col2", (Object)sql[0].toSql());
        List actualNames = sql[0].getAffectedDatabaseObjects().stream().map(o -> o.toString()).collect(Collectors.toList());
        List<String> expectedNames = Arrays.asList("TEST_TABLE.col1", "TEST_TABLE.col2", "TEST_TABLE", "DEFAULT");
        Assert.assertTrue((boolean)actualNames.containsAll(expectedNames));
        Assert.assertTrue((boolean)expectedNames.containsAll(actualNames));
    }

    @Test
    public void testDropMultipleColumnsMSSQL() {
        DropColumnStatement drop = new DropColumnStatement(Arrays.asList(new DropColumnStatement(null, null, "TEST_TABLE", "col1"), new DropColumnStatement(null, null, "TEST_TABLE", "col2")));
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)drop, (Database)new MSSQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Sql[] sql = this.generatorUnderTest.generateSql((SqlStatement)drop, (Database)new MSSQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assert.assertEquals((long)4L, (long)sql.length);
        Assert.assertTrue((sql[0].toSql().contains("TEST_TABLE") && sql[0].toSql().contains("col1") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"ALTER TABLE TEST_TABLE DROP COLUMN col1", (Object)sql[1].toSql());
        Assert.assertTrue((sql[2].toSql().contains("TEST_TABLE") && sql[2].toSql().contains("col2") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"ALTER TABLE TEST_TABLE DROP COLUMN col2", (Object)sql[3].toSql());
    }

    @Test
    public void testDropSimpleColumnsMSSQL() {
        DropColumnStatement drop = new DropColumnStatement(Arrays.asList(new DropColumnStatement(null, null, "TEST_TABLE", "col1")));
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)drop, (Database)new MSSQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Sql[] sql = this.generatorUnderTest.generateSql((SqlStatement)drop, (Database)new MSSQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assert.assertEquals((long)2L, (long)sql.length);
        Assert.assertTrue((sql[0].toSql().contains("TEST_TABLE") && sql[0].toSql().contains("col1") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"ALTER TABLE TEST_TABLE DROP COLUMN col1", (Object)sql[1].toSql());
    }
}

