/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropIndexGenerator;
import liquibase.statement.core.DropIndexStatement;
import org.junit.Assert;
import org.junit.Test;

public class DropIndexGeneratorTest {
    @Test
    public void shouldDropIndexInPostgreSQL() throws Exception {
        DropIndexGenerator dropIndexGenerator = new DropIndexGenerator();
        DropIndexStatement statement = new DropIndexStatement("indexName", "defaultCatalog", "defaultSchema", "aTable", null);
        PostgresDatabase database = new PostgresDatabase();
        TreeSet sqlGenerators = new TreeSet();
        SqlGeneratorChain sqlGenerationChain = new SqlGeneratorChain(sqlGenerators);
        Sql[] sqls = dropIndexGenerator.generateSql(statement, (Database)database, sqlGenerationChain);
        Assert.assertEquals((Object)"DROP INDEX \"defaultSchema\".\"indexName\"", (Object)sqls[0].toSql());
        statement = new DropIndexStatement("index_name", "default_catalog", "default_schema", "a_table", null);
        sqls = dropIndexGenerator.generateSql(statement, (Database)database, sqlGenerationChain);
        Assert.assertEquals((Object)"DROP INDEX default_schema.index_name", (Object)sqls[0].toSql());
        statement = new DropIndexStatement("index_name", null, null, "a_table", null);
        sqls = dropIndexGenerator.generateSql(statement, (Database)database, sqlGenerationChain);
        Assert.assertEquals((Object)"DROP INDEX index_name", (Object)sqls[0].toSql());
    }
}

