/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import liquibase.database.core.InformixDatabase;
import liquibase.sqlgenerator.core.InsertOrUpdateGeneratorInformix;
import liquibase.statement.core.InsertOrUpdateStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InsertOrUpdateGeneratorInformixTest {
    private InsertOrUpdateGeneratorInformix generator;
    private InsertOrUpdateStatement statement;
    private InformixDatabase database;

    @Before
    public void setUp() throws Exception {
        this.generator = new InsertOrUpdateGeneratorInformix();
        this.database = new InformixDatabase();
        this.statement = new InsertOrUpdateStatement("mycatalog", "myschema", "mytable", "pk_col1,pk_col2");
        this.statement.addColumnValue("pk_col1", (Object)1);
        this.statement.addColumnValue("pk_col2", (Object)2);
        this.statement.addColumnValue("col2", (Object)"value2");
        this.statement.addColumnValue("col3", null);
    }

    @Test
    public void getRecordCheck() throws Exception {
        String recordCheck = (String)InsertOrUpdateGeneratorInformixTest.invokePrivateMethod(this.generator, "getRecordCheck", new Object[]{this.statement, this.database, null});
        Assert.assertNotNull((Object)recordCheck);
        Integer lineNumber = 0;
        String[] lines = recordCheck.split("\n");
        Assert.assertEquals((Object)"MERGE INTO mycatalog:myschema.mytable AS dst", (Object)lines[lineNumber]);
        Integer n = lineNumber;
        Integer n2 = lineNumber = Integer.valueOf(lineNumber + 1);
        Assert.assertEquals((Object)"USING (", (Object)lines[lineNumber]);
        n = lineNumber;
        n2 = lineNumber = Integer.valueOf(lineNumber + 1);
        Assert.assertEquals((Object)"\tSELECT 1 AS pk_col1, 2 AS pk_col2, 'value2' AS col2, NULL::INTEGER AS col3", (Object)lines[lineNumber]);
        n = lineNumber;
        n2 = lineNumber = Integer.valueOf(lineNumber + 1);
        Assert.assertEquals((Object)"\tFROM sysmaster:informix.sysdual", (Object)lines[lineNumber]);
        n = lineNumber;
        n2 = lineNumber = Integer.valueOf(lineNumber + 1);
        Assert.assertEquals((Object)") AS src", (Object)lines[lineNumber]);
        n = lineNumber;
        n2 = lineNumber = Integer.valueOf(lineNumber + 1);
        Assert.assertEquals((Object)"ON dst.pk_col1 = src.pk_col1 AND dst.pk_col2 = src.pk_col2", (Object)lines[lineNumber]);
        n = lineNumber;
        n2 = lineNumber = Integer.valueOf(lineNumber + 1);
        Assert.assertEquals((Object)"WHEN NOT MATCHED THEN", (Object)lines[lineNumber]);
    }

    @Test
    public void getInsert() throws Exception {
        String insertStatement = (String)InsertOrUpdateGeneratorInformixTest.invokePrivateMethod(this.generator, "getInsertStatement", new Object[]{this.statement, this.database, null});
        Assert.assertNotNull((Object)insertStatement);
        Integer lineNumber = 0;
        String[] lines = insertStatement.split("\n");
        Assert.assertEquals((Object)"INSERT (dst.pk_col1, dst.pk_col2, dst.col2, dst.col3) VALUES (src.pk_col1, src.pk_col2, src.col2, src.col3)", (Object)lines[lineNumber]);
    }

    @Test
    public void getElse() throws Exception {
        String elseStatement = (String)InsertOrUpdateGeneratorInformixTest.invokePrivateMethod(this.generator, "getElse", new Object[]{this.database});
        Assert.assertNotNull((Object)elseStatement);
        Integer lineNumber = 0;
        String[] lines = elseStatement.split("\n");
        Assert.assertEquals((Object)"", (Object)lines[lineNumber]);
    }

    @Test
    public void getUpdateStatement() throws Exception {
        String updateStatement = (String)InsertOrUpdateGeneratorInformixTest.invokePrivateMethod(this.generator, "getUpdateStatement", new Object[]{this.statement, this.database, null, null});
        Assert.assertNotNull((Object)updateStatement);
        Integer lineNumber = 0;
        String[] lines = updateStatement.split("\n");
        Assert.assertEquals((Object)"WHEN MATCHED THEN", (Object)lines[lineNumber]);
        Integer n = lineNumber;
        Integer n2 = lineNumber = Integer.valueOf(lineNumber + 1);
        Assert.assertEquals((Object)"UPDATE SET dst.col2 = src.col2, dst.col3 = src.col3", (Object)lines[lineNumber]);
    }

    @Test
    public void getUpdateStatementKeysOnly() throws Exception {
        this.statement = new InsertOrUpdateStatement("mycatalog", "myschema", "mytable", "pk_col1,pk_col2");
        this.statement.addColumnValue("pk_col1", (Object)1);
        this.statement.addColumnValue("pk_col2", (Object)2);
        String updateStatement = (String)InsertOrUpdateGeneratorInformixTest.invokePrivateMethod(this.generator, "getUpdateStatement", new Object[]{this.statement, this.database, null, null});
        Assert.assertNotNull((Object)updateStatement);
        Integer lineNumber = 0;
        String[] lines = updateStatement.split("\n");
        Assert.assertEquals((Object)"", (Object)lines[lineNumber]);
    }

    private static Object invokePrivateMethod(Object o, String methodName, Object[] params) {
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)methodName);
        Method[] methods = o.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            try {
                methods[i].setAccessible(true);
                return methods[i].invoke(o, params);
            }
            catch (IllegalAccessException ex) {
                Assert.fail((String)("IllegalAccessException accessing " + methodName));
                continue;
            }
            catch (InvocationTargetException ite) {
                Assert.fail((String)("InvocationTargetException accessing " + methodName));
            }
        }
        Assert.fail((String)("Method '" + methodName + "' not found"));
        return null;
    }
}

