/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.LiquibaseException;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.InsertOrUpdateGeneratorMySQL;
import liquibase.statement.core.InsertOrUpdateStatement;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class InsertOrUpdateGeneratorMySQLTest {
    private static final String CATALOG_NAME = "mycatalog";
    private static final String SCHEMA_NAME = "myschema";
    private static final String TABLE_NAME = "MYTABLE";

    @Test
    public void testGetUpdateStatement_notOnlyUpdate() throws LiquibaseException {
        InsertOrUpdateGeneratorMySQL generator = new InsertOrUpdateGeneratorMySQL();
        InsertOrUpdateStatement insertOrUpdateStatement = new InsertOrUpdateStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME, "pk1");
        MySQLDatabase database = new MySQLDatabase();
        SqlGeneratorChain sqlGeneratorChain = null;
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setValue("value0");
        columnConfig.setName("col0");
        insertOrUpdateStatement.addColumn(columnConfig);
        columnConfig = new ColumnConfig();
        columnConfig.setValue("keyvalue1");
        columnConfig.setName("pk1");
        insertOrUpdateStatement.addColumn(columnConfig);
        String whereClause = generator.getWhereClause(insertOrUpdateStatement, (Database)database);
        String result = generator.getUpdateStatement(insertOrUpdateStatement, (Database)database, whereClause, sqlGeneratorChain);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testGetUpdateStatement_onlyUpdate() throws LiquibaseException {
        InsertOrUpdateGeneratorMySQL generator = new InsertOrUpdateGeneratorMySQL();
        InsertOrUpdateStatement insertOrUpdateStatement = new InsertOrUpdateStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME, "pk1", true);
        MySQLDatabase database = new MySQLDatabase();
        SqlGeneratorChain sqlGeneratorChain = null;
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setValue("value0");
        columnConfig.setName("col0");
        insertOrUpdateStatement.addColumn(columnConfig);
        columnConfig = new ColumnConfig();
        columnConfig.setValue("keyvalue1");
        columnConfig.setName("pk1");
        insertOrUpdateStatement.addColumn(columnConfig);
        String whereClause = generator.getWhereClause(insertOrUpdateStatement, (Database)database);
        String result = generator.getUpdateStatement(insertOrUpdateStatement, (Database)database, whereClause, sqlGeneratorChain);
        Assert.assertEquals((Object)String.format("UPDATE %s.%s SET %s = '%s' WHERE %s = '%s';\n", CATALOG_NAME, TABLE_NAME, "col0", "value0", "pk1", "keyvalue1"), (Object)result);
    }

    @Test
    public void testGenerateSql_notOnlyUpdate() {
        InsertOrUpdateGeneratorMySQL generator = new InsertOrUpdateGeneratorMySQL();
        InsertOrUpdateStatement insertOrUpdateStatement = new InsertOrUpdateStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME, "pk1");
        MySQLDatabase database = new MySQLDatabase();
        SqlGeneratorChain sqlGeneratorChain = null;
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setValue("keyvalue1");
        columnConfig.setName("pk1");
        insertOrUpdateStatement.addColumn(columnConfig);
        columnConfig = new ColumnConfig();
        columnConfig.setValue("value0");
        columnConfig.setName("col0");
        insertOrUpdateStatement.addColumn(columnConfig);
        Sql[] results = generator.generateSql(insertOrUpdateStatement, (Database)database, sqlGeneratorChain);
        Assert.assertThat((Object)results, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)1)));
        Assert.assertEquals((Object)String.format("INSERT INTO %s.%s (%s, %s) VALUES ('%s', '%s')\nON DUPLICATE KEY UPDATE col0 = 'value0'", CATALOG_NAME, TABLE_NAME, "pk1", "col0", "keyvalue1", "value0"), (Object)results[0].toSql());
    }
}

