/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.OracleDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.core.InsertGenerator;
import liquibase.sqlgenerator.core.InsertOrUpdateGeneratorOracle;
import liquibase.sqlgenerator.core.UpdateGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceCurrentValueFunction;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.UpdateStatement;
import org.junit.Assert;
import org.junit.Test;

public class InsertOrUpdateGeneratorOracleTest {
    @Test
    public void ContainsInsertStatement() {
        OracleDatabase database = new OracleDatabase();
        InsertOrUpdateGeneratorOracle generator = new InsertOrUpdateGeneratorOracle();
        InsertOrUpdateStatement statement = new InsertOrUpdateStatement("mycatalog", "myschema", "mytable", "pk_col1");
        statement.addColumnValue("pk_col1", (Object)"value1");
        statement.addColumnValue("col2", (Object)"value2");
        statement.addColumnValue("pk_col1", (Object)"value1");
        statement.addColumnValue("col2", (Object)"value2");
        Sql[] sql = generator.generateSql(statement, (Database)database, null);
        String theSql = sql[0].toSql();
        Assert.assertTrue((boolean)theSql.contains("INSERT INTO mycatalog.mytable (pk_col1, col2) VALUES ('value1', 'value2');"));
        Assert.assertTrue((boolean)theSql.contains("UPDATE mycatalog.mytable"));
        String[] sqlLines = theSql.split("\n");
        int lineToCheck = 0;
        Assert.assertEquals((Object)"DECLARE", (Object)sqlLines[lineToCheck].trim());
        Assert.assertEquals((Object)"v_reccount NUMBER := 0;", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"BEGIN", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"SELECT COUNT(*) INTO v_reccount FROM mycatalog.mytable WHERE pk_col1 = 'value1';", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"IF v_reccount = 0 THEN", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"INSERT INTO mycatalog.mytable (pk_col1, col2) VALUES ('value1', 'value2');", (Object)sqlLines[++lineToCheck]);
        Assert.assertEquals((Object)"ELSIF v_reccount = 1 THEN", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"UPDATE mycatalog.mytable SET col2 = 'value2' WHERE pk_col1 = 'value1';", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"END IF;", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"END;", (Object)sqlLines[++lineToCheck].trim());
    }

    @Test
    public void testOnlyUpdateFlag() {
        OracleDatabase database = new OracleDatabase();
        InsertOrUpdateGeneratorOracle generator = new InsertOrUpdateGeneratorOracle();
        InsertOrUpdateStatement statement = new InsertOrUpdateStatement("mycatalog", "myschema", "mytable", "pk_col1", true);
        statement.addColumnValue("pk_col1", (Object)"value1");
        statement.addColumnValue("col2", (Object)"value2");
        Sql[] sql = generator.generateSql(statement, (Database)database, null);
        String theSql = sql[0].toSql();
        Assert.assertFalse((String)"should not have had insert statement", (boolean)theSql.contains("INSERT INTO mycatalog.mytable (pk_col1, col2) VALUES ('value1', 'value2');"));
        Assert.assertTrue((String)"missing update statement", (boolean)theSql.contains("UPDATE mycatalog.mytable"));
        String[] sqlLines = theSql.split("\n");
        int lineToCheck = 0;
        Assert.assertEquals((Object)"UPDATE mycatalog.mytable SET col2 = 'value2' WHERE pk_col1 = 'value1'", (Object)sqlLines[lineToCheck].trim());
        Assert.assertEquals((String)"Wrong number of lines", (long)1L, (long)sqlLines.length);
    }

    private String prepareInsertStatement(DatabaseFunction databaseSchemaBasedFunction) {
        OracleDatabase database = new OracleDatabase();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        InsertGenerator generator = new InsertGenerator();
        InsertStatement statement = new InsertStatement("mycatalog", "myschema", "mytable");
        ColumnConfig columnConfig = new ColumnConfig();
        if (databaseSchemaBasedFunction instanceof SequenceNextValueFunction) {
            columnConfig.setValueSequenceNext((SequenceNextValueFunction)databaseSchemaBasedFunction);
        } else if (databaseSchemaBasedFunction instanceof SequenceCurrentValueFunction) {
            columnConfig.setValueSequenceCurrent((SequenceCurrentValueFunction)databaseSchemaBasedFunction);
        }
        columnConfig.setName("col3");
        statement.addColumn(columnConfig);
        Sql[] sql = generator.generateSql(statement, (Database)database, null);
        return sql[0].toSql();
    }

    private String prepareUpdateStatement(SequenceNextValueFunction sequenceNextValueFunction) {
        OracleDatabase database = new OracleDatabase();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        UpdateGenerator generator = new UpdateGenerator();
        UpdateStatement statement = new UpdateStatement("mycatalog", "myschema", "mytable");
        statement.addNewColumnValue("col3", (Object)sequenceNextValueFunction);
        Sql[] sql = generator.generateSql(statement, (Database)database, null);
        return sql[0].toSql();
    }

    @Test
    public void testInsertSequenceValWithSchema() {
        SequenceNextValueFunction sequenceNext = new SequenceNextValueFunction("myschema", "my_seq");
        Assert.assertEquals((Object)"INSERT INTO mycatalog.mytable (col3) VALUES (myschema.my_seq.nextval)", (Object)this.prepareInsertStatement((DatabaseFunction)sequenceNext));
    }

    @Test
    public void testInsertSequenceValWithSchemaInWholeStatement() {
        SequenceNextValueFunction sequenceNext = new SequenceNextValueFunction("myschema", "my_seq");
        Assert.assertEquals((Object)"INSERT INTO mycatalog.mytable (col3) VALUES (myschema.my_seq.nextval)", (Object)this.prepareInsertStatement((DatabaseFunction)sequenceNext));
    }

    @Test
    public void testUpdateSequenceValWithSchema() {
        SequenceNextValueFunction sequenceNext = new SequenceNextValueFunction("myschema", "my_seq");
        Assert.assertEquals((Object)"UPDATE mycatalog.mytable SET col3 = myschema.my_seq.nextval", (Object)this.prepareUpdateStatement(sequenceNext));
    }

    @Test
    public void testUpdateSequenceValWithSchemaInWholeStatement() {
        SequenceNextValueFunction sequenceNext = new SequenceNextValueFunction("myschema", "my_seq");
        Assert.assertEquals((Object)"UPDATE mycatalog.mytable SET col3 = myschema.my_seq.nextval", (Object)this.prepareUpdateStatement(sequenceNext));
    }
}

