/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.core.InsertGenerator;
import liquibase.sqlgenerator.core.InsertOrUpdateGeneratorPostgres;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.statement.core.InsertStatement;
import org.junit.Assert;
import org.junit.Test;

public class InsertOrUpdateGeneratorPostgresTest {
    private static final String CATALOG_NAME = "mycatalog";
    private static final String SCHEMA_NAME = "myschema";
    private static final String TABLE_NAME = "mytable";
    private static final String SEQUENCE_NAME = "my_sequence";

    @Test
    public void testInsertSequenceValWithSchema() {
        PostgresDatabase postgresDatabase = new PostgresDatabase();
        InsertGenerator generator = new InsertGenerator();
        InsertStatement statement = new InsertStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setValueSequenceNext(new SequenceNextValueFunction(SCHEMA_NAME, SEQUENCE_NAME));
        columnConfig.setName("col3");
        statement.addColumn(columnConfig);
        Sql[] sql = generator.generateSql(statement, (Database)postgresDatabase, null);
        String theSql = sql[0].toSql();
        Assert.assertEquals((Object)String.format("INSERT INTO %s.%s (col3) VALUES (nextval('%s.%s'))", SCHEMA_NAME, TABLE_NAME, SCHEMA_NAME, SEQUENCE_NAME), (Object)theSql);
    }

    @Test
    public void testInsertSequenceValWithSchemaInWholeStatement() {
        PostgresDatabase postgresDatabase = new PostgresDatabase();
        InsertGenerator generator = new InsertGenerator();
        InsertStatement statement = new InsertStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME);
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setValueSequenceNext(new SequenceNextValueFunction(SCHEMA_NAME, SEQUENCE_NAME));
        columnConfig.setName("col3");
        statement.addColumn(columnConfig);
        Sql[] sql = generator.generateSql(statement, (Database)postgresDatabase, null);
        String theSql = sql[0].toSql();
        Assert.assertEquals((Object)String.format("INSERT INTO %s.%s (col3) VALUES (nextval('%s.%s'))", SCHEMA_NAME, TABLE_NAME, SCHEMA_NAME, SEQUENCE_NAME), (Object)theSql);
    }

    @Test
    public void testOnlyUpdateFlag() {
        PostgresDatabase database = new PostgresDatabase();
        InsertOrUpdateGeneratorPostgres generator = new InsertOrUpdateGeneratorPostgres();
        InsertOrUpdateStatement statement = new InsertOrUpdateStatement(CATALOG_NAME, SCHEMA_NAME, TABLE_NAME, "pk_col1", true);
        statement.addColumnValue("pk_col1", (Object)"value1");
        statement.addColumnValue("col2", (Object)"value2");
        Sql[] sql = generator.generateSql(statement, (Database)database, null);
        String theSql = sql[0].toSql();
        Assert.assertTrue((String)"missing update statement", (boolean)theSql.contains("UPDATE myschema.mytable SET col2 = 'value2' WHERE pk_col1 = 'value1'"));
        Assert.assertFalse((String)"should not have had insert statement", (boolean)theSql.contains("INSERT INTO myschema.mytable (pk_col1, col2) VALUES ('value1', 'value2');"));
    }
}

