/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.HashMap;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.sdk.resource.MockResourceAccessor;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.AbstractSqlGeneratorTest;
import liquibase.sqlgenerator.MockSqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.MarkChangeSetRanGenerator;
import liquibase.statement.core.MarkChangeSetRanStatement;
import org.junit.Assert;
import org.junit.Test;

public class MarkChangeSetRanGeneratorTest
extends AbstractSqlGeneratorTest<MarkChangeSetRanStatement> {
    public MarkChangeSetRanGeneratorTest() throws Exception {
        super(new MarkChangeSetRanGenerator());
    }

    @Override
    protected MarkChangeSetRanStatement createSampleSqlStatement() {
        return new MarkChangeSetRanStatement(new ChangeSet("1", "a", false, false, "c", null, null, null), ChangeSet.ExecType.EXECUTED);
    }

    @Test
    public void generateSql_markRan() {
        Sql[] sqls = new MarkChangeSetRanGenerator().generateSql(new MarkChangeSetRanStatement(new ChangeSet("1", "a", false, false, "c", null, null, null), ChangeSet.ExecType.MARK_RAN), (Database)new MockDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assert.assertEquals((long)1L, (long)sqls.length);
        Assert.assertTrue((String)sqls[0].toSql(), (boolean)sqls[0].toSql().contains("MARK_RAN"));
    }

    @Test
    public void generateSqlWithComplexContext() {
        String changeSetContextExpression = "changeSetContext1 AND changeSetContext2";
        DatabaseChangeLog rootChangeLog = new DatabaseChangeLog();
        rootChangeLog.setContextFilter(new ContextExpression("rootContext1 OR (rootContext2) AND (rootContext3)"));
        DatabaseChangeLog childChangeLog = new DatabaseChangeLog();
        childChangeLog.setContextFilter(new ContextExpression("childChangeLogContext1, childChangeLogContext2 AND childChangeLogContext3"));
        childChangeLog.setIncludeContextFilter(new ContextExpression("includeContext1, includeContext2 AND includeContext3"));
        childChangeLog.setParentChangeLog(rootChangeLog);
        ChangeSet changeSet = new ChangeSet("1", "a", false, false, "c", changeSetContextExpression, null, childChangeLog);
        Sql[] sqls = new MarkChangeSetRanGenerator().generateSql(new MarkChangeSetRanStatement(changeSet, ChangeSet.ExecType.EXECUTED), (Database)new MockDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assert.assertTrue((String)sqls[0].toSql(), (boolean)sqls[0].toSql().contains("(childChangeLogContext1, childChangeLogContext2 AND childChangeLogContext3) AND (includeContext1, includeContext2 AND includeContext3) AND (rootContext1 OR (rootContext2) AND (rootContext3)) AND (changeSetContext1 AND changeSetContext2)"));
    }

    @Test
    public void generateSqlSecondRunUpdatesLabelsContextsComments() {
        String changeSetContextExpression = "changeSetContext1 AND changeSetContext2";
        DatabaseChangeLog rootChangeLog = new DatabaseChangeLog();
        rootChangeLog.setContextFilter(new ContextExpression("rootContext1 OR (rootContext2) AND (rootContext3)"));
        DatabaseChangeLog childChangeLog = new DatabaseChangeLog();
        childChangeLog.setContextFilter(new ContextExpression("childChangeLogContext1, childChangeLogContext2 AND childChangeLogContext3"));
        childChangeLog.setIncludeContextFilter(new ContextExpression("includeContext1, includeContext2 AND includeContext3"));
        childChangeLog.setParentChangeLog(rootChangeLog);
        ChangeSet changeSet = new ChangeSet("1", "a", false, false, "c", changeSetContextExpression, null, childChangeLog);
        changeSet.setComments("comment12345");
        changeSet.setLabels(new Labels("newlabel123"));
        Sql[] sqls = new MarkChangeSetRanGenerator().generateSql(new MarkChangeSetRanStatement(changeSet, ChangeSet.ExecType.RERAN), (Database)new MockDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain());
        String sql = sqls[0].toSql();
        Assert.assertTrue((boolean)sql.contains("COMMENTS = 'comment12345'"));
        Assert.assertTrue((boolean)sql.contains("CONTEXTS = '(childChangeLogContext1, childChangeLogContext2 AND childChangeLogContext3) AND (includeContext1, includeContext2 AND includeContext3) AND (rootContext1 OR (rootContext2) AND (rootContext3)) AND (changeSetContext1 AND changeSetContext2)'"));
        Assert.assertTrue((boolean)sql.contains("LABELS = 'newlabel123'"));
    }

    @Test
    public void getLabelsColumn() {
        DatabaseChangeLog changeLog = new DatabaseChangeLog();
        ChangeSet changeSet = new ChangeSet("1", "a", false, false, "c", null, null, changeLog);
        changeSet.setLabels(null);
        assert (new MarkChangeSetRanGenerator().getLabelsColumn(changeSet) == null);
        changeSet.setLabels(new Labels(""));
        assert (new MarkChangeSetRanGenerator().getLabelsColumn(changeSet) == null);
        changeSet.setLabels(new Labels("a"));
        Assert.assertEquals((Object)"a", (Object)new MarkChangeSetRanGenerator().getLabelsColumn(changeSet));
        changeSet.setLabels(new Labels(new String[]{"a", "b"}));
        Assert.assertEquals((Object)"a,b", (Object)new MarkChangeSetRanGenerator().getLabelsColumn(changeSet));
        changeLog.setIncludeLabels(new Labels("p1"));
        Assert.assertEquals((Object)"p1,a,b", (Object)new MarkChangeSetRanGenerator().getLabelsColumn(changeSet));
        changeSet.setLabels(new Labels("a"));
        Assert.assertEquals((Object)"p1,a", (Object)new MarkChangeSetRanGenerator().getLabelsColumn(changeSet));
        changeSet.setLabels(new Labels());
        Assert.assertEquals((Object)"p1", (Object)new MarkChangeSetRanGenerator().getLabelsColumn(changeSet));
        changeSet.setLabels(null);
        Assert.assertEquals((Object)"p1", (Object)new MarkChangeSetRanGenerator().getLabelsColumn(changeSet));
    }

    @Test
    public void getContextsColumn() {
        DatabaseChangeLog changeLog = new DatabaseChangeLog();
        ChangeSet changeSet = new ChangeSet("1", "a", false, false, "c", null, null, changeLog);
        changeSet.setContextFilter(null);
        assert (new MarkChangeSetRanGenerator().getContextsColumn(changeSet) == null);
        changeSet.setContextFilter(new ContextExpression(""));
        assert (new MarkChangeSetRanGenerator().getContextsColumn(changeSet) == null);
        changeSet.setContextFilter(new ContextExpression("a"));
        Assert.assertEquals((Object)"a", (Object)new MarkChangeSetRanGenerator().getContextsColumn(changeSet));
        changeSet.setContextFilter(new ContextExpression("a or b"));
        Assert.assertEquals((Object)"(a or b)", (Object)new MarkChangeSetRanGenerator().getContextsColumn(changeSet));
        changeLog.setIncludeContextFilter(new ContextExpression("p1"));
        Assert.assertEquals((Object)"p1 AND (a or b)", (Object)new MarkChangeSetRanGenerator().getContextsColumn(changeSet));
        changeSet.setContextFilter(new ContextExpression("a"));
        Assert.assertEquals((Object)"p1 AND a", (Object)new MarkChangeSetRanGenerator().getContextsColumn(changeSet));
        changeSet.setContextFilter(new ContextExpression());
        Assert.assertEquals((Object)"p1", (Object)new MarkChangeSetRanGenerator().getContextsColumn(changeSet));
        changeSet.setContextFilter(null);
        Assert.assertEquals((Object)"p1", (Object)new MarkChangeSetRanGenerator().getContextsColumn(changeSet));
    }

    @Test
    public void makeSureDescriptionIsTruncatedWhenALongPathIsSet() throws Exception {
        MockResourceAccessor resourceAccessor = new MockResourceAccessor();
        String filePath = "This/is/a/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/very/ver/long/test/change/path";
        resourceAccessor.setContent(filePath, "test");
        DatabaseChangeLog changeLog = new DatabaseChangeLog();
        ChangeSet changeSet = new ChangeSet("1", "a", false, false, "c", null, null, changeLog);
        SQLFileChange sqlFileChange = new SQLFileChange();
        sqlFileChange.setPath(filePath);
        changeSet.addChange((Change)sqlFileChange);
        MarkChangeSetRanStatement changeSetRanStatement = new MarkChangeSetRanStatement(changeSet, ChangeSet.ExecType.EXECUTED);
        MarkChangeSetRanGenerator changeSetRanGenerator = new MarkChangeSetRanGenerator();
        HashMap<String, MockResourceAccessor> newMap = new HashMap<String, MockResourceAccessor>();
        newMap.put(Scope.Attr.resourceAccessor.name(), resourceAccessor);
        String sql = (String)Scope.child(newMap, () -> changeSetRanGenerator.generateSql(changeSetRanStatement, (Database)new MockDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain())[0].toSql());
        int descriptionColumnIndex = 18;
        String databaseChangeLogDescription = sql.split(",")[18];
        String truncatedPath = databaseChangeLogDescription.split("path=")[1].split("'")[0];
        Assert.assertTrue((boolean)truncatedPath.endsWith("/..."));
        Assert.assertTrue((truncatedPath.length() <= filePath.length() ? 1 : 0) != 0);
    }
}

