/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.core.SetNullableGenerator;
import liquibase.statement.core.SetNullableStatement;
import org.junit.Assert;
import org.junit.Test;

public class SetNullableGeneratorTest {
    private final SetNullableGenerator generator = new SetNullableGenerator();
    private final OracleDatabase oracle = new OracleDatabase();

    @Test
    public void testGenerateOracleNotNullSql() throws Exception {
        Sql[] sqls = this.generator.generateSql(new SetNullableStatement(null, "schema_name", "table_name", "column_name", null, false), (Database)this.oracle, null);
        Assert.assertEquals((long)1L, (long)sqls.length);
        Sql sql = sqls[0];
        Assert.assertEquals((Object)"ALTER TABLE schema_name.table_name MODIFY column_name NOT NULL", (Object)sql.toSql());
    }

    @Test
    public void testGenerateOracleNotNullSqlWithValidate() throws Exception {
        Sql[] sqls = this.generator.generateSql(new SetNullableStatement(null, "schema_name", "table_name", "column_name", null, false, null, Boolean.valueOf(false)), (Database)this.oracle, null);
        Assert.assertEquals((long)1L, (long)sqls.length);
        Sql sql = sqls[0];
        Assert.assertEquals((Object)"ALTER TABLE schema_name.table_name MODIFY column_name NOT NULL ENABLE NOVALIDATE", (Object)sql.toSql());
    }

    @Test
    public void testGenerateOracleNotNullSqlWithConstraintName() throws Exception {
        Sql[] sqls = this.generator.generateSql(new SetNullableStatement(null, "schema_name", "table_name", "column_name", null, false, "constraint_name"), (Database)this.oracle, null);
        Assert.assertEquals((long)1L, (long)sqls.length);
        Sql sql = sqls[0];
        Assert.assertEquals((Object)"ALTER TABLE schema_name.table_name MODIFY column_name CONSTRAINT constraint_name NOT NULL", (Object)sql.toSql());
    }
}

