/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.TagDatabaseStatement;
import org.junit.Assert;
import org.junit.Test;

public class TagDatabaseGeneratorTest {
    @Test
    public void testMSSQL() throws Exception {
        TagDatabaseStatement statement = new TagDatabaseStatement("v1.0");
        Sql[] sql = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)statement, (Database)new MSSQLDatabase());
        Assert.assertEquals((long)1L, (long)sql.length);
        Assert.assertEquals((Object)"UPDATE changelog SET TAG = 'v1.0' FROM DATABASECHANGELOG AS changelog INNER JOIN (SELECT TOP (1) ID, AUTHOR, FILENAME FROM DATABASECHANGELOG ORDER BY DATEEXECUTED DESC, ORDEREXECUTED DESC) AS latest ON latest.ID = changelog.ID AND latest.AUTHOR = changelog.AUTHOR AND latest.FILENAME = changelog.FILENAME", (Object)sql[0].toSql());
    }

    @Test
    public void testHsql() throws Exception {
        TagDatabaseStatement statement = new TagDatabaseStatement("v1.0");
        Sql[] sql = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)statement, (Database)new HsqlDatabase());
        Assert.assertEquals((long)1L, (long)sql.length);
        Assert.assertEquals((Object)"UPDATE DATABASECHANGELOG SET TAG = 'v1.0' WHERE DATEEXECUTED = (SELECT MAX(DATEEXECUTED) FROM DATABASECHANGELOG)", (Object)sql[0].toSql());
    }
}

