/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.Arrays;
import java.util.List;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.UpdateChangeSetChecksumGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateChangeSetChecksumStatement;
import liquibase.statement.core.UpdateStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class UpdateChangeSetChecksumGeneratorTest {
    public static final String SOME_UPDATED_CHECK_SUM = "SomeUpdatedCheckSum";
    public static final String CHANGESET_SOME_ID = "SomeId";
    public static final String CHANGESET_SOME_AUTHOR = "SomeAuthor";
    public static final String CHANGESET_NORMALIZED_FILE_PATH = "SomeNormalizedFilePath";
    public static final String CHANGESET_STORED_FILE_PATH = "SomeStoredFilePath";
    UpdateChangeSetChecksumGenerator sqlGenerator = new UpdateChangeSetChecksumGenerator();
    @Mock
    Database mockedDatabase;
    @Mock
    ChangeSet mockedChangeSet;
    @Mock
    CheckSum mockedUpdatedCheckSum;
    @Mock
    SqlGeneratorFactory sqlGeneratorFactory;

    @Before
    public void setUp() throws Exception {
        ((Database)Mockito.doReturn((Object)"SomeCatalogName").when((Object)this.mockedDatabase)).getLiquibaseCatalogName();
        ((Database)Mockito.doReturn((Object)"SomeSchemaName").when((Object)this.mockedDatabase)).getLiquibaseSchemaName();
        ((Database)Mockito.doReturn((Object)"SomeChangeLogTableName").when((Object)this.mockedDatabase)).getDatabaseChangeLogTableName();
        ((CheckSum)Mockito.doReturn((Object)SOME_UPDATED_CHECK_SUM).when((Object)this.mockedUpdatedCheckSum)).toString();
        ((ChangeSet)Mockito.doReturn((Object)this.mockedUpdatedCheckSum).when((Object)this.mockedChangeSet)).generateCheckSum();
        ((ChangeSet)Mockito.doReturn((Object)CHANGESET_SOME_ID).when((Object)this.mockedChangeSet)).getId();
        ((ChangeSet)Mockito.doReturn((Object)CHANGESET_SOME_AUTHOR).when((Object)this.mockedChangeSet)).getAuthor();
        ((ChangeSet)Mockito.doReturn((Object)CHANGESET_NORMALIZED_FILE_PATH).when((Object)this.mockedChangeSet)).getFilePath();
        ((ChangeSet)Mockito.doReturn((Object)CHANGESET_STORED_FILE_PATH).when((Object)this.mockedChangeSet)).getStoredFilePath();
        ((Database)Mockito.doAnswer(invocation -> invocation.getArgument(0)).when((Object)this.mockedDatabase)).escapeObjectName(Mockito.anyString(), (Class)Mockito.any());
    }

    @Test
    public void generateSqlUsesStoredFilePathByDefault() {
        List<String> expectedWhereParams = Arrays.asList(CHANGESET_SOME_ID, CHANGESET_SOME_AUTHOR, CHANGESET_STORED_FILE_PATH);
        this.verifyWhereParamsListInTheGeneratedStatement(expectedWhereParams);
    }

    @Test
    public void generateSqlUsesChangesetsNormalizedFilePathWhenChangeSetStoredFilePathIsNull() {
        List<String> expectedWhereParams = Arrays.asList(CHANGESET_SOME_ID, CHANGESET_SOME_AUTHOR, CHANGESET_NORMALIZED_FILE_PATH);
        ((ChangeSet)Mockito.doReturn(null).when((Object)this.mockedChangeSet)).getStoredFilePath();
        this.verifyWhereParamsListInTheGeneratedStatement(expectedWhereParams);
    }

    private void verifyWhereParamsListInTheGeneratedStatement(List<String> expectedWhereParams) {
        try (MockedStatic staticSqlGeneratorFactory = Mockito.mockStatic(SqlGeneratorFactory.class);){
            staticSqlGeneratorFactory.when(SqlGeneratorFactory::getInstance).thenReturn((Object)this.sqlGeneratorFactory);
            UpdateChangeSetChecksumStatement statement = new UpdateChangeSetChecksumStatement(this.mockedChangeSet);
            this.sqlGenerator.generateSql(statement, this.mockedDatabase, null);
            ArgumentCaptor statementCaptor = ArgumentCaptor.forClass(SqlStatement.class);
            ((SqlGeneratorFactory)Mockito.verify((Object)this.sqlGeneratorFactory, (VerificationMode)Mockito.times((int)1))).generateSql((SqlStatement)statementCaptor.capture(), (Database)Mockito.eq((Object)this.mockedDatabase));
            SqlStatement suppliedSqlStatement = (SqlStatement)statementCaptor.getValue();
            Assert.assertTrue((String)"Expect the supplied Statement to be a UpdateStatmeent Instance", (boolean)UpdateStatement.class.isInstance(suppliedSqlStatement));
            UpdateStatement suppliedUpdateStmt = (UpdateStatement)suppliedSqlStatement;
            List suppliedParams = suppliedUpdateStmt.getWhereParameters();
            Assert.assertEquals(expectedWhereParams, (Object)suppliedParams);
        }
    }
}

