/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.core.UpdateGenerator;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Column;
import org.junit.Assert;
import org.junit.Test;

public class UpdateGeneratorTest {
    @Test
    public void testGenerateSqlWithParamPlaceholders() {
        MSSQLDatabase database = new MSSQLDatabase();
        UpdateStatement statement = new UpdateStatement(null, null, "DATABASECHANGELOG").addNewColumnValue("MD5SUM", (Object)"7:e27bf9c0c2313160ef960a15d44ced47").setWhereClause(database.escapeObjectName("ID", Column.class) + " = ? AND " + database.escapeObjectName("AUTHOR", Column.class) + " = ? AND " + database.escapeObjectName("FILENAME", Column.class) + " = ?").addWhereParameters(new Object[]{"SYPA: AUTO_START t\u00fc\u00fcp INT -> TEXT, vaartus 0 00 17 * * ?", "martin", "db/changelog.xml"});
        UpdateGenerator generator = new UpdateGenerator();
        Sql[] sqls = generator.generateSql(statement, (Database)database, null);
        Assert.assertEquals((Object)"UPDATE DATABASECHANGELOG SET MD5SUM = '7:e27bf9c0c2313160ef960a15d44ced47' WHERE ID = N'SYPA: AUTO_START t\u00fc\u00fcp INT -> TEXT, vaartus 0 00 17 * * ?' AND AUTHOR = 'martin' AND FILENAME = 'db/changelog.xml'", (Object)sqls[0].toSql());
    }

    @Test
    public void testGenerateSqlWithNameValuePlaceholderPairs() {
        MSSQLDatabase database = new MSSQLDatabase();
        UpdateStatement statement = new UpdateStatement(null, null, "DATABASECHANGELOG").addNewColumnValue("MD5SUM", (Object)"7:e27bf9c0c2313160ef960a15d44ced47").setWhereClause(":name = :value AND :name = :value AND :name = :value").addWhereColumnName("ID").addWhereColumnName("AUTHOR").addWhereColumnName("FILENAME").addWhereParameters(new Object[]{"SYPA: AUTO_START t\u00fc\u00fcp INT -> TEXT, vaartus 0 00 17 * * ?", "martin", "db/changelog.xml"});
        UpdateGenerator generator = new UpdateGenerator();
        Sql[] sqls = generator.generateSql(statement, (Database)database, null);
        Assert.assertEquals((Object)"UPDATE DATABASECHANGELOG SET MD5SUM = '7:e27bf9c0c2313160ef960a15d44ced47' WHERE ID = N'SYPA: AUTO_START t\u00fc\u00fcp INT -> TEXT, vaartus 0 00 17 * * ?' AND AUTHOR = 'martin' AND FILENAME = 'db/changelog.xml'", (Object)sqls[0].toSql());
    }
}

