/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import liquibase.change.ColumnConfig;
import liquibase.change.core.LoadDataChange;
import liquibase.database.PreparedStatementFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.ExecutablePreparedStatementBase;
import liquibase.statement.ExecutablePreparedStatementBaseMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.util.ReflectionUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ExecutablePreparedStatementBaseTest {
    @Mock
    private PreparedStatementFactory preparedStatementFactoryMock;
    @Mock
    private PreparedStatement preparedStatementMock;
    @Mock
    private ColumnConfig columnConfig1Mock;
    @Mock
    private ColumnConfig columnConfig2Mock;
    @Mock
    private Closeable closeableMock;
    @Mock
    private InputStream inputStreamMock;
    @Spy
    @InjectMocks
    private ExecutablePreparedStatementBaseMock executablePreparedStatementBase;
    private SQLException sqlException = new SQLException();
    private int position = 1;
    private String valueString = UUID.randomUUID().toString();
    private Boolean valueBoolean = Boolean.TRUE;
    private Long valueLong = 1L;
    private Integer valueInteger = 1;
    private Double valueDouble = 1.0;
    private Float valueFloat = Float.valueOf(1.0f);
    private BigDecimal valueBigDecimal = new BigDecimal(1);
    private BigInteger valueBigInteger = new BigInteger("1");
    private Short valueShort = 1;
    private ColumnConfig.ValueNumeric valueNumericDelegate = new ColumnConfig.ValueNumeric("", (Number)this.valueLong);
    private Timestamp valueDateTimestamp = new Timestamp(new java.util.Date().getTime());
    private Time valueDateTime = new Time(new java.util.Date().getTime());
    private java.util.Date valueDateDate = new java.util.Date();
    private String valueBlobFile = "valueBlobFile";
    private ExecutablePreparedStatementBase.LOBContent<InputStream> blobContentLengthInteger = new ExecutablePreparedStatementBase.LOBContent((Object)this.inputStreamMock, 0x7FFFFFFEL);
    private ExecutablePreparedStatementBase.LOBContent<InputStream> blobContentLengthLong = new ExecutablePreparedStatementBase.LOBContent((Object)this.inputStreamMock, Long.MAX_VALUE);
    private IOException ioException = new IOException(this.valueBlobFile);
    private String valueClobFile = "valueClobFile";
    private String encoding = StandardCharsets.UTF_8.displayName();
    private Reader reader = new InputStreamReader(new ByteArrayInputStream(new byte[0]));
    private ExecutablePreparedStatementBase.LOBContent<Reader> clobContentLengthInteger = new ExecutablePreparedStatementBase.LOBContent((Object)this.reader, 0x7FFFFFFEL);
    private ExecutablePreparedStatementBase.LOBContent<Reader> clobContentLengthLong = new ExecutablePreparedStatementBase.LOBContent((Object)this.reader, Long.MAX_VALUE);
    private DatabaseFunction valueComputed = new DatabaseFunction("select * from some_table");
    private Object valueComputedObject = new Object();

    @Before
    public void setUp() {
        ((ColumnConfig)Mockito.doReturn(null).when((Object)this.columnConfig1Mock)).getValueBoolean();
        Field columnsField = ReflectionUtils.findField(ExecutablePreparedStatementBase.class, (String)"columns");
        ReflectionUtils.makeAccessible((Field)columnsField);
        ReflectionUtils.setField((Field)columnsField, (Object)((Object)this.executablePreparedStatementBase), Collections.singletonList(this.columnConfig1Mock));
        Field closeablesField = ReflectionUtils.findField(ExecutablePreparedStatementBase.class, (String)"closeables");
        ReflectionUtils.makeAccessible((Field)closeablesField);
        ReflectionUtils.setField((Field)closeablesField, (Object)((Object)this.executablePreparedStatementBase), Collections.singleton(this.closeableMock));
    }

    @Test
    public void testCreateStream() throws IOException {
        BufferedInputStream bufferedInputStream = (BufferedInputStream)ExecutablePreparedStatementBase.createStream((InputStream)new BufferedInputStream(this.inputStreamMock));
        bufferedInputStream.close();
        ((InputStream)Mockito.verify((Object)this.inputStreamMock)).close();
    }

    @Test
    public void testCreateStream_NotBufferedInputStream() throws IOException {
        BufferedInputStream bufferedInputStream = (BufferedInputStream)ExecutablePreparedStatementBase.createStream((InputStream)this.inputStreamMock);
        bufferedInputStream.close();
        ((InputStream)Mockito.verify((Object)this.inputStreamMock)).close();
    }

    @Test
    public void testExecute() throws DatabaseException, SQLException, IOException {
        ((PreparedStatementFactory)Mockito.doReturn((Object)this.preparedStatementMock).when((Object)this.preparedStatementFactoryMock)).create((String)ArgumentMatchers.any());
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doNothing().when((Object)this.executablePreparedStatementBase))).attachParams((List)ArgumentMatchers.any(), (PreparedStatement)ArgumentMatchers.any());
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doNothing().when((Object)this.executablePreparedStatementBase))).executePreparedStatement((PreparedStatement)ArgumentMatchers.any());
        ((Closeable)Mockito.doNothing().when((Object)this.closeableMock)).close();
        this.executablePreparedStatementBase.execute(this.preparedStatementFactoryMock);
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).generateSql(new ArrayList<ColumnConfig>());
        ((PreparedStatementFactory)Mockito.verify((Object)this.preparedStatementFactoryMock)).create("generateSql");
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).attachParams(new ArrayList(), this.preparedStatementMock);
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).executePreparedStatement(this.preparedStatementMock);
        ((Closeable)Mockito.verify((Object)this.closeableMock)).close();
    }

    @Test
    public void testExecute_attachParamsThrowsSQLException() throws DatabaseException, SQLException, IOException {
        ((PreparedStatementFactory)Mockito.doReturn((Object)this.preparedStatementMock).when((Object)this.preparedStatementFactoryMock)).create((String)ArgumentMatchers.any());
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doThrow((Throwable[])new Throwable[]{this.sqlException}).when((Object)this.executablePreparedStatementBase))).attachParams((List)ArgumentMatchers.any(), (PreparedStatement)ArgumentMatchers.any());
        try {
            this.executablePreparedStatementBase.execute(this.preparedStatementFactoryMock);
            Assert.fail((String)"Should throw DatabaseException");
        }
        catch (DatabaseException e) {
            Assert.assertEquals((Object)this.sqlException, (Object)e.getCause());
        }
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).generateSql(new ArrayList<ColumnConfig>());
        ((PreparedStatementFactory)Mockito.verify((Object)this.preparedStatementFactoryMock)).create("generateSql");
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).attachParams(new ArrayList(), this.preparedStatementMock);
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase), (VerificationMode)Mockito.never()))).executePreparedStatement((PreparedStatement)ArgumentMatchers.any());
        ((Closeable)Mockito.verify((Object)this.closeableMock)).close();
    }

    @Test
    public void testExecute_closeableThrowsIOException() throws DatabaseException, SQLException, IOException {
        ((PreparedStatementFactory)Mockito.doReturn((Object)this.preparedStatementMock).when((Object)this.preparedStatementFactoryMock)).create((String)ArgumentMatchers.any());
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doNothing().when((Object)this.executablePreparedStatementBase))).attachParams((List)ArgumentMatchers.any(), (PreparedStatement)ArgumentMatchers.any());
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doNothing().when((Object)this.executablePreparedStatementBase))).executePreparedStatement((PreparedStatement)ArgumentMatchers.any());
        ((Closeable)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.closeableMock)).close();
        this.executablePreparedStatementBase.execute(this.preparedStatementFactoryMock);
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).generateSql(new ArrayList<ColumnConfig>());
        ((PreparedStatementFactory)Mockito.verify((Object)this.preparedStatementFactoryMock)).create("generateSql");
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).attachParams(new ArrayList(), this.preparedStatementMock);
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).executePreparedStatement(this.preparedStatementMock);
        ((Closeable)Mockito.verify((Object)this.closeableMock)).close();
    }

    @Test
    public void testExecutePreparedStatement() throws SQLException {
        ((PreparedStatement)Mockito.doReturn((Object)true).when((Object)this.preparedStatementMock)).execute();
        this.executablePreparedStatementBase.executePreparedStatement(this.preparedStatementMock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).execute();
    }

    @Test
    public void testAttachParams() throws DatabaseException, SQLException {
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doNothing().when((Object)this.executablePreparedStatementBase))).applyColumnParameter((PreparedStatement)ArgumentMatchers.any(), Mockito.anyInt(), (ColumnConfig)ArgumentMatchers.any());
        this.executablePreparedStatementBase.attachParams(Arrays.asList(this.columnConfig1Mock, this.columnConfig2Mock), this.preparedStatementMock);
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).applyColumnParameter(this.preparedStatementMock, 1, this.columnConfig1Mock);
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).applyColumnParameter(this.preparedStatementMock, 2, this.columnConfig2Mock);
    }

    @Test
    public void testAttachParams_ValueComputed() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueComputed).when((Object)this.columnConfig1Mock)).getValueObject();
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doNothing().when((Object)this.executablePreparedStatementBase))).applyColumnParameter((PreparedStatement)ArgumentMatchers.any(), Mockito.anyInt(), (ColumnConfig)ArgumentMatchers.any());
        this.executablePreparedStatementBase.attachParams(Arrays.asList(this.columnConfig1Mock, this.columnConfig2Mock), this.preparedStatementMock);
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase)))).applyColumnParameter(this.preparedStatementMock, 1, this.columnConfig2Mock);
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.verify((Object)((Object)this.executablePreparedStatementBase), (VerificationMode)Mockito.never()))).applyColumnParameter((PreparedStatement)Mockito.eq((Object)this.preparedStatementMock), Mockito.eq((int)2), (ColumnConfig)ArgumentMatchers.any());
    }

    @Test
    public void testApplyColumnParameter_valueString() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueString).when((Object)this.columnConfig1Mock)).getValue();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setString(this.position, this.valueString);
    }

    @Test
    public void testApplyColumnParameter_valueStringTypeUnknown() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueString).when((Object)this.columnConfig1Mock)).getValue();
        ((ColumnConfig)Mockito.doReturn((Object)LoadDataChange.LOAD_DATA_TYPE.SKIP.name()).when((Object)this.columnConfig1Mock)).getType();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setString(this.position, this.valueString);
    }

    @Test
    public void testApplyColumnParameter_valueStringTypeUuid() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueString).when((Object)this.columnConfig1Mock)).getValue();
        ((ColumnConfig)Mockito.doReturn((Object)LoadDataChange.LOAD_DATA_TYPE.UUID.name()).when((Object)this.columnConfig1Mock)).getType();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setObject(this.position, UUID.fromString(this.valueString));
    }

    @Test
    public void testApplyColumnParameter_valueBoolean() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueBoolean).when((Object)this.columnConfig1Mock)).getValueBoolean();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setBoolean(this.position, this.valueBoolean);
    }

    @Test
    public void testApplyColumnParameter_valueNumericDelegate() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueNumericDelegate).when((Object)this.columnConfig1Mock)).getValueNumeric();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setLong(this.position, this.valueLong);
    }

    @Test
    public void testApplyColumnParameter_valueNumericLong() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueLong).when((Object)this.columnConfig1Mock)).getValueNumeric();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setLong(this.position, this.valueLong);
    }

    @Test
    public void testApplyColumnParameter_valueNumericInteger() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueInteger).when((Object)this.columnConfig1Mock)).getValueNumeric();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setInt(this.position, this.valueInteger);
    }

    @Test
    public void testApplyColumnParameter_valueNumericDouble() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueDouble).when((Object)this.columnConfig1Mock)).getValueNumeric();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setDouble(this.position, this.valueDouble);
    }

    @Test
    public void testApplyColumnParameter_valueNumericFloat() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueFloat).when((Object)this.columnConfig1Mock)).getValueNumeric();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setFloat(this.position, this.valueFloat.floatValue());
    }

    @Test
    public void testApplyColumnParameter_valueNumericBigDecimal() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueBigDecimal).when((Object)this.columnConfig1Mock)).getValueNumeric();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setBigDecimal(this.position, this.valueBigDecimal);
    }

    @Test
    public void testApplyColumnParameter_valueNumericBigInteger() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueBigInteger).when((Object)this.columnConfig1Mock)).getValueNumeric();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setInt(this.position, this.valueBigInteger.intValue());
    }

    @Test
    public void testApplyColumnParameter_valueNumericUnknown() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueShort).when((Object)this.columnConfig1Mock)).getValueNumeric();
        try {
            this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
            Assert.fail((String)"Should throw UnexpectedLiquibaseException");
        }
        catch (UnexpectedLiquibaseException e) {
            Assert.assertEquals((Object)String.format(ExecutablePreparedStatementBase.coreBundle.getString("jdbc.bind.parameter.unknown.numeric.value.type"), this.columnConfig1Mock.getName(), this.columnConfig1Mock.getValueNumeric().toString(), this.columnConfig1Mock.getValueNumeric().getClass().getName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testApplyColumnParameter_valueDateTimestamp() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueDateTimestamp).when((Object)this.columnConfig1Mock)).getValueDate();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setTimestamp(this.position, this.valueDateTimestamp);
    }

    @Test
    public void testApplyColumnParameter_valueDateTime() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueDateTime).when((Object)this.columnConfig1Mock)).getValueDate();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setTime(this.position, this.valueDateTime);
    }

    @Test
    public void testApplyColumnParameter_valueDateDate() throws DatabaseException, SQLException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueDateDate).when((Object)this.columnConfig1Mock)).getValueDate();
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setDate(this.position, new Date(this.valueDateDate.getTime()));
    }

    @Test
    public void testApplyColumnParameter_valueBlobFileLengthInteger() throws LiquibaseException, SQLException, IOException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueBlobFile).when((Object)this.columnConfig1Mock)).getValueBlobFile();
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doReturn(this.blobContentLengthInteger).when((Object)this.executablePreparedStatementBase))).toBinaryStream((String)ArgumentMatchers.any());
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setBlob(this.position, (InputStream)this.blobContentLengthInteger.getContent(), (int)this.blobContentLengthInteger.getLength());
    }

    @Test
    public void testApplyColumnParameter_valueBlobFileLengthLong() throws LiquibaseException, SQLException, IOException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueBlobFile).when((Object)this.columnConfig1Mock)).getValueBlobFile();
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doReturn(this.blobContentLengthLong).when((Object)this.executablePreparedStatementBase))).toBinaryStream((String)ArgumentMatchers.any());
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setBlob(this.position, (InputStream)this.blobContentLengthInteger.getContent(), this.blobContentLengthLong.getLength());
    }

    @Test
    public void testApplyColumnParameter_valueBlobBinaryStreamThrowsIOException() throws LiquibaseException, SQLException, IOException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueBlobFile).when((Object)this.columnConfig1Mock)).getValueBlobFile();
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doThrow((Throwable[])new Throwable[]{this.ioException}).when((Object)this.executablePreparedStatementBase))).toBinaryStream((String)ArgumentMatchers.any());
        try {
            this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
            Assert.fail((String)"Should throw DatabaseException");
        }
        catch (DatabaseException e) {
            Assert.assertEquals((Object)this.valueBlobFile, (Object)e.getMessage());
            Assert.assertEquals((Object)this.ioException, (Object)e.getCause());
        }
    }

    @Test
    public void testApplyColumnParameter_valueClobFileLenghtInteger() throws LiquibaseException, SQLException, IOException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueClobFile).when((Object)this.columnConfig1Mock)).getValueClobFile();
        ((ColumnConfig)Mockito.doReturn((Object)this.valueClobFile).when((Object)this.columnConfig1Mock)).getEncoding();
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doReturn(this.clobContentLengthInteger).when((Object)this.executablePreparedStatementBase))).toCharacterStream((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setCharacterStream(this.position, (Reader)this.clobContentLengthInteger.getContent(), (int)this.clobContentLengthInteger.getLength());
    }

    @Test
    public void testApplyColumnParameter_valueClobFileLengthLong() throws LiquibaseException, SQLException, IOException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueClobFile).when((Object)this.columnConfig1Mock)).getValueClobFile();
        ((ColumnConfig)Mockito.doReturn((Object)this.valueClobFile).when((Object)this.columnConfig1Mock)).getEncoding();
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doReturn(this.clobContentLengthLong).when((Object)this.executablePreparedStatementBase))).toCharacterStream((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setCharacterStream(this.position, (Reader)this.clobContentLengthInteger.getContent(), this.clobContentLengthLong.getLength());
    }

    @Test
    public void testApplyColumnParameter_valueClobBinaryStreamThrowsIOException() throws LiquibaseException, SQLException, IOException {
        ((ColumnConfig)Mockito.doReturn((Object)this.valueClobFile).when((Object)this.columnConfig1Mock)).getValueClobFile();
        ((ColumnConfig)Mockito.doReturn((Object)this.valueClobFile).when((Object)this.columnConfig1Mock)).getEncoding();
        ((ExecutablePreparedStatementBaseMock)((Object)Mockito.doThrow((Throwable[])new Throwable[]{this.ioException}).when((Object)this.executablePreparedStatementBase))).toCharacterStream((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        try {
            this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
            Assert.fail((String)"Should throw DatabaseException");
        }
        catch (DatabaseException e) {
            Assert.assertEquals((Object)this.valueBlobFile, (Object)e.getMessage());
            Assert.assertEquals((Object)this.ioException, (Object)e.getCause());
        }
    }

    @Test
    public void testApplyColumnParameter_valueNull() throws LiquibaseException, SQLException, IOException {
        this.executablePreparedStatementBase.applyColumnParameter(this.preparedStatementMock, this.position, this.columnConfig1Mock);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock)).setNull(this.position, 0);
    }

    @Test
    public void dateParameterTypeIsDeclared() throws DatabaseException, SQLException {
        ExecutablePreparedStatementBase preparedStatement = new ExecutablePreparedStatementBase(null, null, null, null, null, null, null){

            public boolean continueOnError() {
                return false;
            }

            protected String generateSql(List<ColumnConfig> cols) {
                return null;
            }
        };
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        ColumnConfig dateColumn = new ColumnConfig();
        dateColumn.setName("date_column");
        dateColumn.setType("DATE");
        columns.add(dateColumn);
        DummyPreparedStatement stmt = new DummyPreparedStatement();
        preparedStatement.attachParams(columns, (PreparedStatement)stmt);
        Assert.assertNotEquals((long)0L, (long)stmt.getParamTypes().get(1).intValue());
        Assert.assertEquals((long)91L, (long)stmt.getParamTypes().get(1).intValue());
        stmt = new DummyPreparedStatement();
        dateColumn.setType("DATETIME");
        preparedStatement.attachParams(columns, (PreparedStatement)stmt);
        Assert.assertNotEquals((long)0L, (long)stmt.getParamTypes().get(1).intValue());
        Assert.assertEquals((long)93L, (long)stmt.getParamTypes().get(1).intValue());
        stmt = new DummyPreparedStatement();
        dateColumn.setType("TIMESTAMP");
        preparedStatement.attachParams(columns, (PreparedStatement)stmt);
        Assert.assertNotEquals((long)0L, (long)stmt.getParamTypes().get(1).intValue());
        Assert.assertEquals((long)93L, (long)stmt.getParamTypes().get(1).intValue());
        stmt = new DummyPreparedStatement();
        dateColumn.setType("STRING");
        preparedStatement.attachParams(columns, (PreparedStatement)stmt);
        Assert.assertEquals((long)0L, (long)stmt.getParamTypes().get(1).intValue());
    }

    private static class DummyPreparedStatement
    implements PreparedStatement {
        private Map<Integer, Integer> paramTypes = new HashMap<Integer, Integer>();

        private DummyPreparedStatement() {
        }

        public Map<Integer, Integer> getParamTypes() {
            return this.paramTypes;
        }

        @Override
        public ResultSet executeQuery(String sql) throws SQLException {
            return null;
        }

        @Override
        public int executeUpdate(String sql) throws SQLException {
            return 0;
        }

        @Override
        public void close() throws SQLException {
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            return 0;
        }

        @Override
        public void setMaxFieldSize(int max) throws SQLException {
        }

        @Override
        public int getMaxRows() throws SQLException {
            return 0;
        }

        @Override
        public void setMaxRows(int max) throws SQLException {
        }

        @Override
        public void setEscapeProcessing(boolean enable) throws SQLException {
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            return 0;
        }

        @Override
        public void setQueryTimeout(int seconds) throws SQLException {
        }

        @Override
        public void cancel() throws SQLException {
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return null;
        }

        @Override
        public void clearWarnings() throws SQLException {
        }

        @Override
        public void setCursorName(String name) throws SQLException {
        }

        @Override
        public boolean execute(String sql) throws SQLException {
            return false;
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return null;
        }

        @Override
        public int getUpdateCount() throws SQLException {
            return 0;
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            return false;
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return 0;
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
        }

        @Override
        public int getFetchSize() throws SQLException {
            return 0;
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            return 0;
        }

        @Override
        public int getResultSetType() throws SQLException {
            return 0;
        }

        @Override
        public void addBatch(String sql) throws SQLException {
        }

        @Override
        public void clearBatch() throws SQLException {
        }

        @Override
        public int[] executeBatch() throws SQLException {
            return null;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return null;
        }

        @Override
        public boolean getMoreResults(int current) throws SQLException {
            return false;
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            return null;
        }

        @Override
        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            return 0;
        }

        @Override
        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            return 0;
        }

        @Override
        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            return 0;
        }

        @Override
        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            return false;
        }

        @Override
        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            return false;
        }

        @Override
        public boolean execute(String sql, String[] columnNames) throws SQLException {
            return false;
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            return 0;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return false;
        }

        @Override
        public void setPoolable(boolean poolable) throws SQLException {
        }

        @Override
        public boolean isPoolable() throws SQLException {
            return false;
        }

        @Override
        public void closeOnCompletion() throws SQLException {
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            return null;
        }

        @Override
        public int executeUpdate() throws SQLException {
            return 0;
        }

        @Override
        public void setNull(int parameterIndex, int sqlType) throws SQLException {
            this.paramTypes.put(parameterIndex, sqlType);
        }

        @Override
        public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        }

        @Override
        public void setByte(int parameterIndex, byte x) throws SQLException {
        }

        @Override
        public void setShort(int parameterIndex, short x) throws SQLException {
        }

        @Override
        public void setInt(int parameterIndex, int x) throws SQLException {
        }

        @Override
        public void setLong(int parameterIndex, long x) throws SQLException {
        }

        @Override
        public void setFloat(int parameterIndex, float x) throws SQLException {
        }

        @Override
        public void setDouble(int parameterIndex, double x) throws SQLException {
        }

        @Override
        public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        }

        @Override
        public void setString(int parameterIndex, String x) throws SQLException {
        }

        @Override
        public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        }

        @Override
        public void setDate(int parameterIndex, Date x) throws SQLException {
        }

        @Override
        public void setTime(int parameterIndex, Time x) throws SQLException {
        }

        @Override
        public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        }

        @Override
        public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        }

        @Override
        public void clearParameters() throws SQLException {
        }

        @Override
        public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        }

        @Override
        public void setObject(int parameterIndex, Object x) throws SQLException {
        }

        @Override
        public boolean execute() throws SQLException {
            return false;
        }

        @Override
        public void addBatch() throws SQLException {
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        }

        @Override
        public void setRef(int parameterIndex, Ref x) throws SQLException {
        }

        @Override
        public void setBlob(int parameterIndex, Blob x) throws SQLException {
        }

        @Override
        public void setClob(int parameterIndex, Clob x) throws SQLException {
        }

        @Override
        public void setArray(int parameterIndex, Array x) throws SQLException {
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return null;
        }

        @Override
        public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        }

        @Override
        public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        }

        @Override
        public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        }

        @Override
        public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
            this.paramTypes.put(parameterIndex, sqlType);
        }

        @Override
        public void setURL(int parameterIndex, URL x) throws SQLException {
        }

        @Override
        public ParameterMetaData getParameterMetaData() throws SQLException {
            return null;
        }

        @Override
        public void setRowId(int parameterIndex, RowId x) throws SQLException {
        }

        @Override
        public void setNString(int parameterIndex, String value) throws SQLException {
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        }

        @Override
        public void setNClob(int parameterIndex, NClob value) throws SQLException {
        }

        @Override
        public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        }

        @Override
        public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        }

        @Override
        public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        }

        @Override
        public void setClob(int parameterIndex, Reader reader) throws SQLException {
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        }
    }
}

