/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.ColumnConfig;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.PreparedStatementFactory;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.UpdateExecutablePreparedStatement;
import liquibase.structure.core.Column;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class UpdateExecutablePreparedStatementTest {
    @Mock
    private ChangeSet changeSet;
    @Mock
    private ResourceAccessor resourceAccessor;
    @Mock
    private JdbcConnection connection;
    @Mock
    private PreparedStatement ps;
    private Database database;
    private PreparedStatementFactory preparedStatementFactory;

    @Before
    public void setUp() throws Exception {
        BDDMockito.given((Object)this.connection.prepareStatement(ArgumentMatchers.anyString())).willReturn((Object)this.ps);
        this.database = new MSSQLDatabase();
        this.preparedStatementFactory = new PreparedStatementFactory(this.connection);
    }

    @Test
    public void testContinueOnError() {
        Assert.assertFalse((boolean)new UpdateExecutablePreparedStatement(this.database, "catalogName", "schemaName", "tableName", new ArrayList(), this.changeSet, this.resourceAccessor).continueOnError());
    }

    @Test
    public void testExecuteWithParamPlaceholders() throws Exception {
        UpdateExecutablePreparedStatement statement = new UpdateExecutablePreparedStatement(this.database, null, null, "DATABASECHANGELOG", new ArrayList<ColumnConfig>(Arrays.asList(new ColumnConfig().setName("MD5SUM").setValue("7:e27bf9c0c2313160ef960a15d44ced47"))), this.changeSet, this.resourceAccessor).setWhereClause(this.database.escapeObjectName("ID", Column.class) + " = ? AND " + this.database.escapeObjectName("AUTHOR", Column.class) + " = ? AND " + this.database.escapeObjectName("FILENAME", Column.class) + " = ?").addWhereParameters(new Object[]{"SYPA: AUTO_START t\u00fc\u00fcp INT -> TEXT, vaartus 0 00 17 * * ?", "martin", "db/changelog.xml"});
        statement.execute(this.preparedStatementFactory);
        ((JdbcConnection)Mockito.verify((Object)this.connection)).prepareStatement("UPDATE DATABASECHANGELOG SET MD5SUM = ? WHERE ID = N'SYPA: AUTO_START t\u00fc\u00fcp INT -> TEXT, vaartus 0 00 17 * * ?' AND AUTHOR = 'martin' AND FILENAME = 'db/changelog.xml'");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(1, "7:e27bf9c0c2313160ef960a15d44ced47");
    }

    @Test
    public void testExecuteWithNameValuePlaceholderPairs() throws Exception {
        UpdateExecutablePreparedStatement statement = new UpdateExecutablePreparedStatement(this.database, null, null, "DATABASECHANGELOG", new ArrayList<ColumnConfig>(Arrays.asList(new ColumnConfig().setName("MD5SUM").setValue("7:e27bf9c0c2313160ef960a15d44ced47"))), this.changeSet, this.resourceAccessor).setWhereClause(":name = :value AND :name = :value AND :name = :value").addWhereColumnName("ID").addWhereColumnName("AUTHOR").addWhereColumnName("FILENAME").addWhereParameters(new Object[]{"SYPA: AUTO_START t\u00fc\u00fcp INT -> TEXT, vaartus 0 00 17 * * ?", "martin", "db/changelog.xml"});
        statement.execute(this.preparedStatementFactory);
        ((JdbcConnection)Mockito.verify((Object)this.connection)).prepareStatement("UPDATE DATABASECHANGELOG SET MD5SUM = ? WHERE ID = N'SYPA: AUTO_START t\u00fc\u00fcp INT -> TEXT, vaartus 0 00 17 * * ?' AND AUTHOR = 'martin' AND FILENAME = 'db/changelog.xml'");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(1, "7:e27bf9c0c2313160ef960a15d44ced47");
    }

    @Test
    public void testExecute() throws DatabaseException, SQLException {
        OracleDatabase database = new OracleDatabase();
        ColumnConfig columnConfig1 = new ColumnConfig();
        columnConfig1.setName("column1");
        columnConfig1.setAutoIncrement(Boolean.valueOf(true));
        columnConfig1.setValue("value1");
        ColumnConfig columnConfig2 = new ColumnConfig();
        columnConfig2.setName("column2");
        columnConfig2.setValue("value2");
        ColumnConfig columnConfig3 = new ColumnConfig();
        columnConfig3.setName("column3");
        columnConfig3.setValue("value3");
        ColumnConfig columnConfig4 = new ColumnConfig();
        columnConfig4.setName("column4");
        columnConfig4.setValue("value4");
        UpdateExecutablePreparedStatement updateExecutablePreparedStatement = new UpdateExecutablePreparedStatement((Database)database, "catalogName", "schemaName", "tableName", Arrays.asList(columnConfig1, columnConfig2, columnConfig3, columnConfig4), this.changeSet, this.resourceAccessor);
        updateExecutablePreparedStatement.execute(this.preparedStatementFactory);
        ((JdbcConnection)Mockito.verify((Object)this.connection)).prepareStatement("UPDATE catalogName.tableName SET column1 = ?, column2 = ?, column3 = ?, column4 = ?");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(1, "value1");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(2, "value2");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(3, "value3");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(4, "value4");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ps});
    }

    @Test
    public void testExecuteWithClobAndComputedValue() throws Exception {
        UpdateExecutablePreparedStatement statement = new UpdateExecutablePreparedStatement(this.database, null, null, "DATABASECHANGELOG", new ArrayList<ColumnConfig>(Arrays.asList(new ColumnConfig().setName("MD5SUM").setValue("7:e27bf9c0c2313160ef960a15d44ced47"), new ColumnConfig().setName("DATEEXECUTED").setValueDate("GETDATE()"))), this.changeSet, this.resourceAccessor);
        statement.execute(this.preparedStatementFactory);
        ((JdbcConnection)Mockito.verify((Object)this.connection)).prepareStatement("UPDATE DATABASECHANGELOG SET MD5SUM = ?, DATEEXECUTED = GETDATE()");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(1, "7:e27bf9c0c2313160ef960a15d44ced47");
        ((PreparedStatement)Mockito.verify((Object)this.ps, (VerificationMode)Mockito.never())).setNull(Mockito.eq((int)2), Mockito.anyInt());
    }

    @Test
    public void testExecute_ValueComputed() throws DatabaseException, SQLException {
        OracleDatabase database = new OracleDatabase();
        ColumnConfig columnConfig1 = new ColumnConfig();
        columnConfig1.setName("column1");
        columnConfig1.setAutoIncrement(Boolean.valueOf(true));
        columnConfig1.setValue("value1");
        ColumnConfig columnConfig2 = new ColumnConfig();
        columnConfig2.setName("column2");
        columnConfig2.setValue("value2");
        ColumnConfig columnConfig3 = new ColumnConfig();
        columnConfig3.setName("column3");
        columnConfig3.setValueComputed(new DatabaseFunction("select * from abc where x=y"));
        ColumnConfig columnConfig4 = new ColumnConfig();
        columnConfig4.setName("column4");
        columnConfig4.setValue("value4");
        UpdateExecutablePreparedStatement updateExecutablePreparedStatement = new UpdateExecutablePreparedStatement((Database)database, "catalogName", "schemaName", "tableName", Arrays.asList(columnConfig1, columnConfig2, columnConfig3, columnConfig4), this.changeSet, this.resourceAccessor);
        updateExecutablePreparedStatement.execute(this.preparedStatementFactory);
        ((JdbcConnection)Mockito.verify((Object)this.connection)).prepareStatement("UPDATE catalogName.tableName SET column1 = ?, column2 = ?, column3 = select * from abc where x=y, column4 = ?");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(1, "value1");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(2, "value2");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(3, "value4");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ps});
    }
}

