/*
 * Decompiled with CFR 0.152.
 */
package liquibase.test;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import liquibase.util.StringUtil;

public class Assert {
    public static void assertSetsEqual(String[] expected, Set<String> set) {
        org.junit.Assert.assertEquals((String)("Set size does not match: " + StringUtil.join((String[])expected, (String)",") + " vs " + StringUtil.join(set, (String)",")), (long)expected.length, (long)set.size());
        for (String string : expected) {
            org.junit.Assert.assertTrue((String)("Missing expected element " + string), (boolean)set.contains(string));
        }
        for (String found : set) {
            org.junit.Assert.assertTrue((String)("Unexpected element in set: " + found), (boolean)Arrays.asList(expected).contains(found));
        }
    }

    public static void assertArraysEqual(String[] expected, String[] array) {
        org.junit.Assert.assertEquals((String)"Set size does not match", (long)expected.length, (long)array.length);
        for (int i = 0; i < expected.length; ++i) {
            org.junit.Assert.assertEquals((String)("Difference in element " + i), (Object)expected[i], (Object)array[i]);
        }
    }

    public static void assertListsEqual(Object[] expected, List list, AssertFunction assertFunction) {
        org.junit.Assert.assertEquals((String)"List size does not match", (long)expected.length, (long)list.size());
        for (int i = 0; i < expected.length; ++i) {
            assertFunction.check("Difference in element " + i, expected[i], list.get(i));
        }
    }

    public static abstract class AssertFunction {
        public abstract void check(String var1, Object var2, Object var3);
    }
}

