/*
 * Decompiled with CFR 0.152.
 */
package liquibase.test;

import java.util.Optional;
import java.util.function.Predicate;
import liquibase.diff.DiffResult;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;
import org.junit.Assert;

public class DiffResultAssert {
    private DiffResult diff;

    private DiffResultAssert() {
    }

    public static DiffResultAssert assertThat(DiffResult diffResult) {
        DiffResultAssert da = new DiffResultAssert();
        da.diff = diffResult;
        return da;
    }

    public DiffResultAssert containsMissingForeignKeyWithName(String fkName) {
        return this.checkContainsMissingObject(ForeignKey.class, foreignKey -> foreignKey.getName().equalsIgnoreCase(fkName), "Foreign key with name " + fkName + " not found");
    }

    public <T extends DatabaseObject> DiffResultAssert containsMissingObject(Class<T> type, Predicate<T> condition) {
        return this.checkContainsMissingObject(type, condition, type.getSimpleName() + " satisfying condition not found");
    }

    public DiffResultAssert containsMissingObject(DatabaseObject object) {
        return this.checkContainsMissingObject(object.getClass(), object::equals, object + " not found");
    }

    private <T extends DatabaseObject> DiffResultAssert checkContainsMissingObject(Class<T> type, Predicate<T> condition, String failMessage) {
        Optional first = this.diff.getMissingObjects(type).stream().filter(condition).findFirst();
        if (!first.isPresent()) {
            Assert.fail((String)failMessage);
        }
        return this;
    }
}

