/*
 * Decompiled with CFR 0.152.
 */
package liquibase.test;

import java.util.Optional;
import java.util.function.Predicate;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import org.junit.Assert;

public class SnapshotAssert {
    private DatabaseSnapshot snapshot;

    private SnapshotAssert(DatabaseSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public static SnapshotAssert assertThat(DatabaseSnapshot snapshot) {
        return new SnapshotAssert(snapshot);
    }

    public SnapshotAssert containsObject(DatabaseObject object) {
        return this.checkContainsObject(object.getClass(), object::equals, object + " not found");
    }

    public <T extends DatabaseObject> SnapshotAssert containsObject(Class<T> type, Predicate<T> condition) {
        return this.checkContainsObject(type, condition, type.getSimpleName() + " satisfying condition not found");
    }

    private <T extends DatabaseObject> SnapshotAssert checkContainsObject(Class<T> type, Predicate<T> condition, String failMessage) {
        Optional first = this.snapshot.get(type).stream().filter(condition).findFirst();
        if (!first.isPresent()) {
            Assert.fail((String)failMessage);
        }
        return this;
    }
}

