/*
 * Decompiled with CFR 0.152.
 */
package liquibase.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class TestContext {
    private static TestContext instance = new TestContext();
    private Set<Database> allDatabases;
    private ResourceAccessor resourceAccessor;

    public static TestContext getInstance() {
        return instance;
    }

    public Set<Database> getAllDatabases() {
        if (this.allDatabases == null) {
            this.allDatabases = new HashSet<Database>();
            this.allDatabases.addAll(DatabaseFactory.getInstance().getImplementedDatabases());
            ArrayList<Database> toRemove = new ArrayList<Database>();
            for (Database database : this.allDatabases) {
                if (database instanceof SQLiteDatabase || database instanceof MockDatabase) {
                    toRemove.add(database);
                }
                database.setCanCacheLiquibaseTableInfo(false);
            }
            this.allDatabases.removeAll(toRemove);
        }
        return this.allDatabases;
    }

    public File findCoreJvmProjectRoot() throws URISyntaxException {
        return new File(this.findStandardProjectRoot().getParentFile(), "liquibase-standard");
    }

    public File findIntegrationTestProjectRoot() throws URISyntaxException {
        return new File(this.findStandardProjectRoot().getParentFile(), "liquibase-integration-tests");
    }

    public File findStandardProjectRoot() throws URISyntaxException {
        URI uri = new URI(this.getClass().getClassLoader().getResource("liquibase/test/TestContext.class").toExternalForm());
        if (!uri.isOpaque()) {
            File thisClassFile = new File(uri);
            return thisClassFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
        }
        uri = new URI(this.getClass().getClassLoader().getResource("liquibase/integration/commandline/Main.class").toExternalForm());
        if (!uri.isOpaque()) {
            File thisClassFile = new File(uri);
            return new File(thisClassFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "liquibase-standard");
        }
        uri = new URI(this.getClass().getClassLoader().getResource("liquibase/dbtest/AbstractIntegrationTest.class").toExternalForm());
        if (!uri.isOpaque()) {
            File thisClassFile = new File(uri);
            return new File(thisClassFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "liquibase-standard");
        }
        throw new IllegalStateException("Cannot find liquibase-standard project root");
    }

    public ResourceAccessor getTestResourceAccessor() throws URISyntaxException, MalformedURLException {
        if (this.resourceAccessor == null) {
            this.resourceAccessor = new ClassLoaderResourceAccessor((ClassLoader)new URLClassLoader(new URL[]{new File(TestContext.getInstance().findCoreJvmProjectRoot(), "/target/classes").toURI().toURL(), new File(TestContext.getInstance().findCoreJvmProjectRoot(), "/target/test-classes").toURI().toURL(), new File(TestContext.getInstance().findStandardProjectRoot(), "/target/classes").toURI().toURL(), new File(TestContext.getInstance().findStandardProjectRoot(), "/target/test-classes").toURI().toURL()}));
        }
        return this.resourceAccessor;
    }
}

