/*
 * Decompiled with CFR 0.152.
 */
package liquibase.verify;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Pattern;
import liquibase.util.StringUtil;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.TestName;

public class AbstractVerifyTest {
    @Rule
    public TestName name = new TestName();

    protected static class TestState {
        private File stateFile;
        private File savedStateDir;
        private String testName;
        private String testGroup;
        private String stateName;
        private Type type;
        private StringBuilder stateContent = new StringBuilder();

        public TestState(String testName, String testGroup, String stateName, Type type) {
            this.type = type;
            this.testName = testName;
            this.testGroup = testGroup;
            this.stateName = stateName;
            File liquibaseRootDir = new File("");
            if (liquibaseRootDir.getAbsolutePath().endsWith("liquibase-standard")) {
                liquibaseRootDir = liquibaseRootDir.getAbsoluteFile().getParentFile();
            }
            this.savedStateDir = new File(liquibaseRootDir.getAbsoluteFile(), "liquibase-standard/src/test/java/liquibase/verify/saved_state/" + testName + "/" + testGroup);
            this.stateFile = new File(this.savedStateDir, stateName + "." + type.name().toLowerCase());
        }

        public void addComment(String comment) {
            this.stateContent.append(Pattern.compile("^", 8).matcher(comment).replaceAll("-- ")).append("\n");
        }

        public void addValue(String value) {
            this.stateContent.append(value).append("\n");
        }

        public void save() throws Exception {
            this.savedStateDir.mkdirs();
            BufferedWriter outputStream = new BufferedWriter(new FileWriter(this.stateFile));
            outputStream.write(this.stateContent.toString());
            outputStream.flush();
            outputStream.close();
        }

        public void test() throws Exception {
            String existingContent = this.readExistingValue();
            if ("".equals(existingContent) && StringUtil.trimToNull((String)this.stateContent.toString()) != null) {
                this.save();
            } else {
                try {
                    String stateContentString = this.stateContent.toString();
                    stateContentString = stateContentString.replaceAll("\r\n", "\n").trim();
                    existingContent = existingContent.replaceAll("\r\n", "\n").trim();
                    boolean contentsAreEqual = stateContentString.equals(existingContent);
                    Assert.assertTrue((String)String.format("Unexpected difference in %s\nOriginal:\n[%s]\nNew state:\n[%s]\n", this.stateFile.getAbsolutePath(), existingContent, stateContentString), (boolean)contentsAreEqual);
                }
                catch (ComparisonFailure e) {
                    if ("overwrite".equals(System.getProperty("liquibase.verify.mode"))) {
                        this.save();
                    }
                    throw e;
                }
            }
        }

        private String readExistingValue() throws IOException {
            StringBuilder content = new StringBuilder();
            if (this.stateFile.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(this.stateFile));
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                reader.close();
            }
            return content.toString();
        }

        public static enum Type {
            SQL;

        }
    }
}

