/*
 * Decompiled with CFR 0.152.
 */
package liquibase.verify.change;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.ScopeManager;
import liquibase.TestScopeManager;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeMetaData;
import liquibase.change.ChangeParameterMetaData;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MockDatabase;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;
import liquibase.verify.AbstractVerifyTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class VerifyChangeClassesTest
extends AbstractVerifyTest {
    @BeforeClass
    public static void setUpClass() {
        Scope.setScopeManager((ScopeManager)new TestScopeManager());
    }

    @Test
    public void compareGeneratedSqlWithExpectedSqlForMinimalChangesets() throws Exception {
        ChangeFactory changeFactory = (ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class);
        for (String changeName : changeFactory.getDefinedChanges()) {
            if ("addDefaultValue".equals(changeName) || "createProcedure".equals(changeName) || "changeWithNestedTags".equals(changeName) || "sampleChange".equals(changeName) || "output".equals(changeName) || "tagDatabase".equals(changeName)) continue;
            for (Database database : DatabaseFactory.getInstance().getImplementedDatabases()) {
                if (database.getShortName() == null || database instanceof MockDatabase) continue;
                AbstractVerifyTest.TestState state = new AbstractVerifyTest.TestState(this.name.getMethodName(), changeName, database.getShortName(), AbstractVerifyTest.TestState.Type.SQL);
                state.addComment("Database: " + database.getShortName());
                Change change = changeFactory.create(changeName);
                if (!change.supports(database) || change.generateStatementsVolatile(database)) continue;
                ChangeMetaData changeMetaData = ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData(change);
                TreeSet requiredParams = new TreeSet(changeMetaData.getRequiredParameters(database).keySet());
                if ("dropColumn".equalsIgnoreCase(changeName)) {
                    requiredParams.add("columnName");
                }
                if ("setColumnRemarks".equalsIgnoreCase(changeName)) {
                    requiredParams.add("remarks");
                }
                if ("setTableRemarks".equalsIgnoreCase(changeName)) {
                    requiredParams.add("remarks");
                }
                if ("createView".equalsIgnoreCase(changeName)) {
                    requiredParams.add("selectQuery");
                }
                if ("alterSequence".equalsIgnoreCase(changeName)) {
                    if ("h2".equalsIgnoreCase(database.getShortName())) {
                        requiredParams.add("ordered");
                    } else if ("hsqldb".equalsIgnoreCase(database.getShortName())) {
                        requiredParams.add("minValue");
                    } else {
                        requiredParams.add("incrementBy");
                    }
                }
                if ("dropNotNullConstraint".equalsIgnoreCase(changeName) && "oracle".equalsIgnoreCase(database.getShortName())) {
                    requiredParams.add("columnName");
                }
                if (database instanceof Db2zDatabase && "addLookupTable".equalsIgnoreCase(changeName)) {
                    requiredParams.add("newColumnDataType");
                }
                for (String paramName : requiredParams) {
                    ChangeParameterMetaData param = (ChangeParameterMetaData)changeMetaData.getParameters().get(paramName);
                    Object paramValue = param.getExampleValue(database);
                    String serializedValue = this.formatParameter(paramValue);
                    state.addComment("Change Parameter: " + param.getParameterName() + "=" + serializedValue);
                    param.setValue(change, paramValue);
                }
                ValidationErrors errors = change.validate(database);
                Assert.assertFalse((String)("Validation errors for " + changeMetaData.getName() + " on " + database.getShortName() + ": " + errors.toString()), (boolean)errors.hasErrors());
                SqlStatement[] sqlStatements = new SqlStatement[]{};
                try {
                    sqlStatements = change.generateStatements(database);
                }
                catch (UnexpectedLiquibaseException ex) {
                    if (ex.getCause() instanceof IOException) {
                        // empty if block
                    }
                }
                for (SqlStatement statement : sqlStatements) {
                    Sql[] sql = SqlGeneratorFactory.getInstance().generateSql(statement, database);
                    if (sql == null) {
                        Scope.getCurrentScope().getLog(this.getClass()).severe("Null sql for " + statement + " on " + database.getShortName());
                        continue;
                    }
                    for (Sql line : sql) {
                        String sqlLine = line.toSql();
                        Assert.assertFalse((String)("Change " + changeMetaData.getName() + " contains 'null' for " + database.getShortName() + ": " + sqlLine), (boolean)sqlLine.contains(" null "));
                        state.addValue(sqlLine + ";");
                    }
                }
                state.test();
            }
        }
    }

    @Test
    public void lessThanMinimumFails() throws Exception {
        ChangeFactory changeFactory = (ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class);
        for (String changeName : changeFactory.getDefinedChanges()) {
            for (Database database : DatabaseFactory.getInstance().getImplementedDatabases()) {
                Change change;
                if (database.getShortName() == null || "createProcedure".equals(changeName) || !(change = changeFactory.create(changeName)).supports(database) || change.generateStatementsVolatile(database)) continue;
                ChangeMetaData changeMetaData = ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData(change);
                ArrayList requiredParams = new ArrayList(changeMetaData.getRequiredParameters(database).keySet());
                for (String paramName : requiredParams) {
                    ChangeParameterMetaData param = (ChangeParameterMetaData)changeMetaData.getParameters().get(paramName);
                    Object paramValue = param.getExampleValue(database);
                    param.setValue(change, paramValue);
                }
                for (int i = 0; i < requiredParams.size(); ++i) {
                    String paramToRemove = (String)requiredParams.get(i);
                    ChangeParameterMetaData paramToRemoveMetadata = (ChangeParameterMetaData)changeMetaData.getParameters().get(paramToRemove);
                    Object currentValue = paramToRemoveMetadata.getCurrentValue(change);
                    paramToRemoveMetadata.setValue(change, null);
                    Assert.assertTrue((String)("No errors even with " + changeMetaData.getName() + " with a null " + paramToRemove + " on " + database.getShortName()), (boolean)change.validate(database).hasErrors());
                    paramToRemoveMetadata.setValue(change, currentValue);
                }
            }
        }
    }

    @Ignore
    @Test
    public void extraParamsIsValidSql() throws Exception {
        ChangeFactory changeFactory = (ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class);
        for (String changeName : changeFactory.getDefinedChanges()) {
            if ("addDefaultValue".equals(changeName) || "createProcedure".equals(changeName)) continue;
            for (Database database : DatabaseFactory.getInstance().getImplementedDatabases()) {
                if (database.getShortName() == null) continue;
                AbstractVerifyTest.TestState state = new AbstractVerifyTest.TestState(this.name.getMethodName(), changeName, database.getShortName(), AbstractVerifyTest.TestState.Type.SQL);
                state.addComment("Database: " + database.getShortName());
                Change baseChange = changeFactory.create(changeName);
                if (!baseChange.supports(database) || baseChange.generateStatementsVolatile(database)) continue;
                ChangeMetaData changeMetaData = ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData(baseChange);
                ArrayList<String> optionalParameters = new ArrayList<String>(changeMetaData.getOptionalParameters(database).keySet());
                Collections.sort(optionalParameters);
                List<List<String>> paramLists = this.powerSet(optionalParameters);
                Collections.sort(paramLists, new Comparator<List<String>>(){

                    @Override
                    public int compare(List<String> o1, List<String> o2) {
                        int comp = Integer.compare(o1.size(), o2.size());
                        if (comp == 0) {
                            comp = StringUtil.join(o1, (String)",").compareTo(StringUtil.join(o2, (String)","));
                        }
                        return comp;
                    }
                });
                for (List<String> permutation : paramLists) {
                    String serializedValue;
                    Object paramValue;
                    ChangeParameterMetaData param;
                    Change change = changeFactory.create(changeName);
                    for (String paramName : new TreeSet(changeMetaData.getRequiredParameters(database).keySet())) {
                        param = (ChangeParameterMetaData)changeMetaData.getParameters().get(paramName);
                        paramValue = param.getExampleValue(database);
                        serializedValue = this.formatParameter(paramValue);
                        state.addComment("Required Change Parameter: " + param.getParameterName() + "=" + serializedValue);
                        param.setValue(change, paramValue);
                    }
                    for (String paramName : permutation) {
                        param = (ChangeParameterMetaData)changeMetaData.getParameters().get(paramName);
                        if (!param.supports(database)) continue;
                        paramValue = param.getExampleValue(database);
                        serializedValue = this.formatParameter(paramValue);
                        state.addComment("Optional Change Parameter: " + param.getParameterName() + "=" + serializedValue);
                        param.setValue(change, paramValue);
                    }
                    ValidationErrors errors = change.validate(database);
                    Assert.assertFalse((String)("Validation errors for " + changeMetaData.getName() + " on " + database.getShortName() + ": " + errors.toString()), (boolean)errors.hasErrors());
                }
            }
        }
    }

    private List<List<String>> powerSet(List<String> baseSet) {
        LinkedList<List<String>> returnList = new LinkedList<List<String>>();
        if (baseSet.isEmpty()) {
            returnList.add(new ArrayList());
            return returnList;
        }
        ArrayList<String> list = new ArrayList<String>(baseSet);
        String head = (String)list.get(0);
        ArrayList<String> rest = new ArrayList<String>(list.subList(1, list.size()));
        for (List<String> set : this.powerSet(rest)) {
            ArrayList<String> newSet = new ArrayList<String>();
            newSet.add(head);
            newSet.addAll(set);
            returnList.add(newSet);
            returnList.add(set);
        }
        return returnList;
    }

    private String formatParameter(Object paramValue) {
        String serializedValue;
        if (paramValue instanceof Collection) {
            serializedValue = "[";
            for (Object obj : (Collection)paramValue) {
                serializedValue = serializedValue + this.formatParameter(obj) + ", ";
            }
            serializedValue = serializedValue + "]";
        } else {
            serializedValue = paramValue instanceof LiquibaseSerializable ? new StringChangeLogSerializer().serialize((LiquibaseSerializable)paramValue, true) : paramValue.toString();
        }
        return serializedValue;
    }
}

