/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc;

import dev.onvoid.webrtc.RTCStatsType;
import java.util.Map;

public class RTCStats {
    private final long timestamp;
    private final RTCStatsType type;
    private final String id;
    private final Map<String, Object> attributes;

    protected RTCStats(long timestamp, RTCStatsType type, String id, Map<String, Object> attributes) {
        this.timestamp = timestamp;
        this.type = type;
        this.id = id;
        this.attributes = attributes;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public RTCStatsType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(RTCStats.class.getSimpleName());
        builder.append("[ timestamp: ").append(this.timestamp).append(", type: ").append((Object)this.type).append(", id: ").append(this.id);
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            builder.append(", ").append(entry.getKey()).append(": ");
            RTCStats.appendValue(builder, entry.getValue());
        }
        builder.append("]");
        return builder.toString();
    }

    private static void appendValue(StringBuilder builder, Object value) {
        if (value instanceof Object[]) {
            Object[] arrayValue = (Object[])value;
            builder.append('[');
            for (int i = 0; i < arrayValue.length; ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                RTCStats.appendValue(builder, arrayValue[i]);
            }
            builder.append(']');
        } else if (value instanceof String) {
            builder.append('\"').append(value).append('\"');
        } else {
            builder.append(value);
        }
    }
}

