/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.audio;

import dev.onvoid.webrtc.internal.DisposableNativeObject;
import dev.onvoid.webrtc.internal.NativeLoader;
import dev.onvoid.webrtc.media.audio.AudioDevice;
import dev.onvoid.webrtc.media.audio.AudioLayer;
import dev.onvoid.webrtc.media.audio.AudioSink;
import dev.onvoid.webrtc.media.audio.AudioSource;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AudioDeviceModule
extends DisposableNativeObject {
    private Map.Entry<AudioSink, Long> sinkEntry;
    private Map.Entry<AudioSource, Long> sourceEntry;

    public AudioDeviceModule() {
        this.initialize(AudioLayer.kPlatformDefaultAudio);
    }

    public AudioDeviceModule(AudioLayer audioLayer) {
        this.initialize(audioLayer);
    }

    @Override
    public void dispose() {
        if (Objects.nonNull(this.sinkEntry)) {
            this.removeSinkInternal(this.sinkEntry.getValue());
        }
        if (Objects.nonNull(this.sourceEntry)) {
            this.removeSourceInternal(this.sourceEntry.getValue());
        }
        this.sinkEntry = null;
        this.sourceEntry = null;
        this.disposeInternal();
    }

    public void setAudioSink(AudioSink sink) {
        Objects.requireNonNull(sink);
        if (Objects.nonNull(this.sinkEntry)) {
            if (sink.equals(this.sinkEntry.getKey())) {
                return;
            }
            this.removeSinkInternal(this.sinkEntry.getValue());
        }
        long nativeSink = this.addSinkInternal(sink);
        this.sinkEntry = new AbstractMap.SimpleEntry<AudioSink, Long>(sink, nativeSink);
    }

    public void setAudioSource(AudioSource source) {
        Objects.requireNonNull(source);
        if (Objects.nonNull(this.sourceEntry)) {
            if (source.equals(this.sourceEntry.getKey())) {
                return;
            }
            this.removeSourceInternal(this.sourceEntry.getValue());
        }
        long nativeSource = this.addSourceInternal(source);
        this.sourceEntry = new AbstractMap.SimpleEntry<AudioSource, Long>(source, nativeSource);
    }

    public native void initPlayout();

    public native void stopPlayout();

    public native void startPlayout();

    public native void initRecording();

    public native void stopRecording();

    public native void startRecording();

    public native List<AudioDevice> getPlayoutDevices();

    public native List<AudioDevice> getRecordingDevices();

    public native void setPlayoutDevice(AudioDevice var1);

    public native void setRecordingDevice(AudioDevice var1);

    public native boolean isSpeakerMuted();

    public native boolean isMicrophoneMuted();

    public native int getSpeakerVolume();

    public native int getMaxSpeakerVolume();

    public native int getMinSpeakerVolume();

    public native int getMicrophoneVolume();

    public native int getMaxMicrophoneVolume();

    public native int getMinMicrophoneVolume();

    public native void setSpeakerVolume(int var1);

    public native void setSpeakerMute(boolean var1);

    public native void setMicrophoneVolume(int var1);

    public native void setMicrophoneMute(boolean var1);

    private native void initialize(AudioLayer var1);

    private native void disposeInternal();

    private native long addSinkInternal(AudioSink var1);

    private native void removeSinkInternal(long var1);

    private native long addSourceInternal(AudioSource var1);

    private native void removeSourceInternal(long var1);

    static {
        try {
            NativeLoader.loadLibrary("webrtc-java");
        }
        catch (Exception e) {
            throw new RuntimeException("Load library 'webrtc-java' failed", e);
        }
    }
}

