/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.audio;

import dev.onvoid.webrtc.internal.DisposableNativeObject;
import java.util.Objects;

public class AudioResampler
extends DisposableNativeObject {
    public AudioResampler() {
        this.initialize();
    }

    public AudioResampler(int sourceSampleRate, int targetSampleRate, int channels) {
        this.initialize(AudioResampler.getSamplesPerChannel(sourceSampleRate), AudioResampler.getSamplesPerChannel(targetSampleRate), channels);
    }

    public int resample(byte[] samplesIn, int srcSamplesPerChannel, byte[] samplesOut, int dstSamplesPerChannel, int channels) {
        Objects.requireNonNull(samplesIn);
        Objects.requireNonNull(samplesOut);
        int maxSamplesOut = samplesOut.length / 2;
        if (dstSamplesPerChannel > maxSamplesOut) {
            throw new IllegalArgumentException("Insufficient samples output length");
        }
        return this.resampleInternal(samplesIn, srcSamplesPerChannel, samplesOut, maxSamplesOut, channels);
    }

    @Override
    public native void dispose();

    private native void initialize();

    private native void initialize(int var1, int var2, int var3);

    private native int resampleInternal(byte[] var1, int var2, byte[] var3, int var4, int var5);

    public static int getSamplesPerChannel(int sampleRate) {
        return sampleRate / 100;
    }
}

