/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.video;

import dev.onvoid.webrtc.internal.RefCountedObject;
import dev.onvoid.webrtc.media.video.I420Buffer;
import dev.onvoid.webrtc.media.video.VideoFrameBuffer;
import java.nio.ByteBuffer;

public class NativeI420Buffer
extends RefCountedObject
implements I420Buffer {
    private final ByteBuffer dataY;
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final int strideY;
    private final int strideU;
    private final int strideV;
    private final int width;
    private final int height;

    private NativeI420Buffer(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV) {
        this.width = width;
        this.height = height;
        this.dataY = dataY;
        this.strideY = strideY;
        this.dataU = dataU;
        this.strideU = strideU;
        this.dataV = dataV;
        this.strideV = strideV;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public I420Buffer toI420() {
        return this;
    }

    @Override
    public VideoFrameBuffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        return NativeI420Buffer.cropAndScale(this, cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight);
    }

    public String toString() {
        return String.format("%s@%d [width=%s, height=%s]", NativeI420Buffer.class.getSimpleName(), this.hashCode(), this.width, this.height);
    }

    public static native NativeI420Buffer allocate(int var0, int var1);

    private static I420Buffer wrap(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV) {
        if (dataY == null || dataU == null || dataV == null) {
            throw new IllegalArgumentException("Data buffers cannot be null");
        }
        if (!(dataY.isDirect() && dataU.isDirect() && dataV.isDirect())) {
            throw new IllegalArgumentException("Data buffers must be direct byte buffers");
        }
        dataY = dataY.slice();
        dataU = dataU.slice();
        dataV = dataV.slice();
        int chromaWidth = (width + 1) / 2;
        int chromaHeight = (height + 1) / 2;
        NativeI420Buffer.checkCapacity(dataY, width, height, strideY);
        NativeI420Buffer.checkCapacity(dataU, chromaWidth, chromaHeight, strideU);
        NativeI420Buffer.checkCapacity(dataV, chromaWidth, chromaHeight, strideV);
        return new NativeI420Buffer(width, height, dataY, strideY, dataU, strideU, dataV, strideV);
    }

    private static VideoFrameBuffer cropAndScale(I420Buffer buffer, int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        if (cropWidth == scaleWidth && cropHeight == scaleHeight) {
            ByteBuffer dataY = buffer.getDataY();
            ByteBuffer dataU = buffer.getDataU();
            ByteBuffer dataV = buffer.getDataV();
            dataY.position(cropX + cropY * buffer.getStrideY());
            dataU.position(cropX / 2 + cropY / 2 * buffer.getStrideU());
            dataV.position(cropX / 2 + cropY / 2 * buffer.getStrideV());
            return NativeI420Buffer.wrap(scaleWidth, scaleHeight, dataY.slice(), buffer.getStrideY(), dataU.slice(), buffer.getStrideU(), dataV.slice(), buffer.getStrideV());
        }
        NativeI420Buffer newBuffer = NativeI420Buffer.allocate(scaleWidth, scaleHeight);
        NativeI420Buffer.cropAndScale(buffer.getDataY(), buffer.getStrideY(), buffer.getDataU(), buffer.getStrideU(), buffer.getDataV(), buffer.getStrideV(), cropX, cropY, cropWidth, cropHeight, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataU(), newBuffer.getStrideU(), newBuffer.getDataV(), newBuffer.getStrideV(), scaleWidth, scaleHeight);
        return newBuffer;
    }

    private static void checkCapacity(ByteBuffer data, int width, int height, int stride) {
        int minCapacity = stride * (height - 1) + width;
        if (data.capacity() < minCapacity) {
            throw new IllegalArgumentException("Buffer must be at least " + minCapacity + " bytes, but was " + data.capacity());
        }
    }

    private static native void cropAndScale(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8, int var9, ByteBuffer var10, int var11, ByteBuffer var12, int var13, ByteBuffer var14, int var15, int var16, int var17);
}

