/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.video;

import dev.onvoid.webrtc.media.FourCC;
import dev.onvoid.webrtc.media.video.I420Buffer;
import dev.onvoid.webrtc.media.video.VideoFrameBuffer;
import java.nio.ByteBuffer;

public final class VideoBufferConverter {
    public static void convertFromI420(VideoFrameBuffer src, byte[] dst, FourCC fourCC) throws Exception {
        if (src == null) {
            throw new NullPointerException("Source buffer must not be null");
        }
        if (dst == null) {
            throw new NullPointerException("Destination buffer must not be null");
        }
        I420Buffer i420 = src.toI420();
        VideoBufferConverter.I420toByteArray(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dst, i420.getWidth(), i420.getHeight(), fourCC.value());
    }

    public static void convertFromI420(VideoFrameBuffer src, ByteBuffer dst, FourCC fourCC) throws Exception {
        if (src == null) {
            throw new NullPointerException("Source buffer must not be null");
        }
        if (dst == null) {
            throw new NullPointerException("Destination buffer must not be null");
        }
        I420Buffer i420 = src.toI420();
        if (dst.isDirect()) {
            VideoBufferConverter.I420toDirectBuffer(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dst, i420.getWidth(), i420.getHeight(), fourCC.value());
        } else {
            byte[] arrayBuffer = null;
            if (dst.hasArray()) {
                arrayBuffer = dst.array();
            } else {
                arrayBuffer = new byte[dst.remaining()];
                dst.get(arrayBuffer);
            }
            VideoBufferConverter.I420toByteArray(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), arrayBuffer, i420.getWidth(), i420.getHeight(), fourCC.value());
        }
    }

    private static native void I420toByteArray(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, byte[] var6, int var7, int var8, int var9) throws Exception;

    private static native void I420toDirectBuffer(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, int var8, int var9) throws Exception;
}

