/*
 * Copyright 2021 Alex Andres
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dev.onvoid.webrtc.internal;

/**
 * This ClassLoader is capable of loading Java classes regardless of what thread
 * classes should be loaded from. Such a ClassLoader is needed when a Java class
 * lookup is performed from a native thread and there is no app-specific frame
 * on the stack.
 *
 * @author Alex Andres
 */
class NativeClassLoader {

	static ClassLoader getClassLoader() {
		ClassLoader loader = NativeClassLoader.class.getClassLoader();

		if (loader == null) {
			throw new RuntimeException("Get NativeClassLoader failed");
		}

		return loader;
	}

}
