/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc;

import dev.onvoid.webrtc.media.MediaType;
import java.util.Map;

public class RTCRtpCodecCapability {
    private final MediaType mediaType;
    private final String name;
    private final int clockRate;
    private final int channels;
    private final Map<String, String> sdpFmtp;

    public RTCRtpCodecCapability(MediaType mediaType, String name, int clockRate, int channels, Map<String, String> sdpFmtp) {
        this.mediaType = mediaType;
        this.name = name;
        this.clockRate = clockRate;
        this.channels = channels;
        this.sdpFmtp = sdpFmtp;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getName() {
        return this.name;
    }

    public int getClockRate() {
        return this.clockRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public Map<String, String> getSDPFmtp() {
        return this.sdpFmtp;
    }

    public String getMimeType() {
        return this.mediaType.toString().toLowerCase() + "/" + this.name;
    }

    public String toString() {
        return String.format("%s [mediaType=%s, name=%s, clockRate=%s, channels=%s, sdpFmtp=%s]", new Object[]{RTCRtpCodecCapability.class.getSimpleName(), this.mediaType, this.name, this.clockRate, this.channels, this.sdpFmtp});
    }
}

