/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.internal;

import java.io.File;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NativeLoader {
    private static final Set<String> LOADED_LIB_SET = ConcurrentHashMap.newKeySet();

    public static void loadLibrary(String libName) throws Exception {
        if (LOADED_LIB_SET.contains(libName)) {
            return;
        }
        String libFileName = System.mapLibraryName(libName);
        String tempName = NativeLoader.removeExtension(libFileName);
        String ext = NativeLoader.getExtension(libFileName);
        Path tempPath = Files.createTempFile(tempName, ext, new FileAttribute[0]);
        File tempFile = tempPath.toFile();
        try (InputStream is = NativeLoader.class.getClassLoader().getResourceAsStream(libFileName);){
            Files.copy(is, tempPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            tempFile.delete();
            throw e;
        }
        try {
            System.load(tempPath.toAbsolutePath().toString());
            LOADED_LIB_SET.add(libName);
        }
        catch (Exception e) {
            tempFile.delete();
            throw e;
        }
        if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            tempFile.delete();
        } else {
            tempFile.deleteOnExit();
        }
    }

    private static String getExtension(String fileName) {
        int index = NativeLoader.getExtensionIndex(fileName);
        if (index < 0) {
            return "";
        }
        return fileName.substring(index);
    }

    private static String removeExtension(String fileName) {
        int index = NativeLoader.getExtensionIndex(fileName);
        if (index < 0) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    private static int getExtensionIndex(String fileName) {
        String file = fileName.replace("\\", "/");
        int extSeparator = file.lastIndexOf(".");
        int pathSeparator = file.lastIndexOf("/");
        if (pathSeparator > extSeparator) {
            return -1;
        }
        return extSeparator;
    }
}

