/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.configcat;

import com.configcat.ConfigCatClient;
import com.configcat.EvaluationDetails;
import com.configcat.User;
import dev.openfeature.contrib.providers.configcat.ConfigCatProviderConfig;
import dev.openfeature.contrib.providers.configcat.ContextTransformer;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.GeneralError;
import dev.openfeature.sdk.exceptions.ProviderNotReadyError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCatProvider
extends EventProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigCatProvider.class);
    private static final String NAME = "ConfigCat";
    public static final String PROVIDER_NOT_YET_INITIALIZED = "provider not yet initialized";
    public static final String UNKNOWN_ERROR = "unknown error";
    private ConfigCatProviderConfig configCatProviderConfig;
    private ConfigCatClient configCatClient;
    private ProviderState state = ProviderState.NOT_READY;
    private AtomicBoolean isInitialized = new AtomicBoolean(false);

    public ConfigCatProvider(ConfigCatProviderConfig configCatProviderConfig) {
        this.configCatProviderConfig = configCatProviderConfig;
    }

    public void initialize(EvaluationContext evaluationContext) throws Exception {
        boolean initialized = this.isInitialized.getAndSet(true);
        if (initialized) {
            throw new GeneralError("already initialized");
        }
        super.initialize(evaluationContext);
        this.configCatClient = ConfigCatClient.get((String)this.configCatProviderConfig.getSdkKey(), this.configCatProviderConfig.getOptions());
        this.configCatProviderConfig.postInit();
        this.state = ProviderState.READY;
        log.info("finished initializing provider, state: {}", (Object)this.state);
        this.configCatClient.getHooks().addOnConfigChanged(map -> {
            ProviderEventDetails providerEventDetails = ProviderEventDetails.builder().flagsChanged(new ArrayList(map.keySet())).message("config changed").build();
            this.emitProviderReady(providerEventDetails);
        });
        this.configCatClient.getHooks().addOnError(errorMessage -> {
            ProviderEventDetails providerEventDetails = ProviderEventDetails.builder().message(errorMessage).build();
            this.emitProviderError(providerEventDetails);
        });
    }

    public Metadata getMetadata() {
        return () -> NAME;
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.getEvaluation(Boolean.class, key, defaultValue, ctx);
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.getEvaluation(String.class, key, defaultValue, ctx);
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.getEvaluation(Integer.class, key, defaultValue, ctx);
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.getEvaluation(Double.class, key, defaultValue, ctx);
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        return this.getEvaluation(Value.class, key, defaultValue, ctx);
    }

    private <T> ProviderEvaluation<T> getEvaluation(Class<T> classOfT, String key, T defaultValue, EvaluationContext ctx) {
        Object evaluatedValue;
        EvaluationDetails evaluationDetails;
        User user;
        if (!ProviderState.READY.equals((Object)this.state)) {
            if (ProviderState.NOT_READY.equals((Object)this.state)) {
                throw new ProviderNotReadyError(PROVIDER_NOT_YET_INITIALIZED);
            }
            throw new GeneralError(UNKNOWN_ERROR);
        }
        User user2 = user = ctx == null ? null : ContextTransformer.transform(ctx);
        if (classOfT.isAssignableFrom(Value.class)) {
            String defaultValueStr = defaultValue == null ? null : ((Value)defaultValue).asString();
            evaluationDetails = this.configCatClient.getValueDetails(String.class, key, user, (Object)defaultValueStr);
            evaluatedValue = evaluationDetails.getValue() == null ? null : Value.objectToValue((Object)evaluationDetails.getValue());
        } else {
            evaluationDetails = this.configCatClient.getValueDetails(classOfT, key, user, defaultValue);
            evaluatedValue = evaluationDetails.getValue();
        }
        return ProviderEvaluation.builder().value(evaluatedValue).variant(evaluationDetails.getVariationId()).build();
    }

    public void shutdown() {
        super.shutdown();
        log.info("shutdown");
        if (this.configCatClient != null) {
            this.configCatClient.close();
        }
        this.state = ProviderState.NOT_READY;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static String getNAME() {
        return NAME;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConfigCatClient getConfigCatClient() {
        return this.configCatClient;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProviderState getState() {
        return this.state;
    }
}

