/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.envvar;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;

public class EnvironmentKeyTransformer {
    private static final UnaryOperator<String> TO_LOWER_CASE = StringUtils::lowerCase;
    private static final UnaryOperator<String> TO_UPPER_CASE = StringUtils::upperCase;
    private static final UnaryOperator<String> TO_CAMEL_CASE = s -> CaseUtils.toCamelCase((String)s, (boolean)false, (char[])new char[]{'_'});
    private static final UnaryOperator<String> REPLACE_DOT_WITH_UNDERSCORE = s -> StringUtils.replaceChars((String)s, (String)".", (String)"_");
    private static final UnaryOperator<String> REPLACE_UNDERSCORE_WITH_DOT = s -> StringUtils.replaceChars((String)s, (String)"_", (String)".");
    private static final UnaryOperator<String> REPLACE_HYPHEN_WITH_UNDERSCORE = s -> StringUtils.replaceChars((String)s, (String)"-", (String)"_");
    private final Function<String, String> transformation;

    public String transformKey(String key) {
        return this.transformation.apply(key);
    }

    public EnvironmentKeyTransformer andThen(EnvironmentKeyTransformer another) {
        return new EnvironmentKeyTransformer(this.transformation.andThen(another::transformKey));
    }

    public static EnvironmentKeyTransformer toLowerCaseTransformer() {
        return new EnvironmentKeyTransformer(TO_LOWER_CASE);
    }

    public static EnvironmentKeyTransformer toUpperCaseTransformer() {
        return new EnvironmentKeyTransformer(TO_UPPER_CASE);
    }

    public static EnvironmentKeyTransformer toCamelCaseTransformer() {
        return new EnvironmentKeyTransformer(TO_CAMEL_CASE);
    }

    public static EnvironmentKeyTransformer replaceUnderscoreWithDotTransformer() {
        return new EnvironmentKeyTransformer(REPLACE_UNDERSCORE_WITH_DOT);
    }

    public static EnvironmentKeyTransformer replaceDotWithUnderscoreTransformer() {
        return new EnvironmentKeyTransformer(REPLACE_DOT_WITH_UNDERSCORE);
    }

    public static EnvironmentKeyTransformer hyphenCaseToScreamingSnake() {
        return new EnvironmentKeyTransformer(REPLACE_HYPHEN_WITH_UNDERSCORE).andThen(EnvironmentKeyTransformer.toUpperCaseTransformer());
    }

    public static EnvironmentKeyTransformer doNothing() {
        return new EnvironmentKeyTransformer(s -> s);
    }

    @Generated
    public EnvironmentKeyTransformer(Function<String, String> transformation) {
        this.transformation = transformation;
    }
}

