/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableContext;
import dev.openfeature.sdk.MutableStructure;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Convert {
    public static EvaluationContext convertProtobufStructToContext(Struct struct) {
        HashMap values = new HashMap();
        struct.getFieldsMap().forEach((key, value) -> values.put(key, Convert.convertAny(value)));
        return new ImmutableContext(values);
    }

    public static Value convertObjectResponse(Struct protobuf) {
        return Convert.convertProtobufMap(protobuf.getFieldsMap());
    }

    public static Struct convertContext(EvaluationContext ctx) {
        Map ctxMap = ctx.asMap();
        ctxMap.put("targetingKey", new Value(ctx.getTargetingKey()));
        return Convert.convertMap(ctxMap).getStructValue();
    }

    public static com.google.protobuf.Value convertAny(Value value) {
        if (value.isList()) {
            return Convert.convertList(value.asList());
        }
        if (value.isStructure()) {
            return Convert.convertMap(value.asStructure().asMap());
        }
        return Convert.convertPrimitive(value);
    }

    public static Value convertAny(com.google.protobuf.Value protobuf) {
        if (protobuf.hasListValue()) {
            return Convert.convertList(protobuf.getListValue());
        }
        if (protobuf.hasStructValue()) {
            return Convert.convertProtobufMap(protobuf.getStructValue().getFieldsMap());
        }
        return Convert.convertPrimitive(protobuf);
    }

    public static com.google.protobuf.Value convertMap(Map<String, Value> map) {
        HashMap values = new HashMap();
        map.keySet().forEach(key -> {
            Value value = (Value)map.get(key);
            values.put(key, Convert.convertAny(value));
        });
        Struct struct = Struct.newBuilder().putAllFields(values).build();
        return com.google.protobuf.Value.newBuilder().setStructValue(struct).build();
    }

    public static Value convertProtobufMap(Map<String, com.google.protobuf.Value> map) {
        return new Value(Convert.convertProtobufMapToStructure(map));
    }

    public static Structure convertProtobufMapToStructure(Map<String, com.google.protobuf.Value> map) {
        HashMap values = new HashMap();
        map.keySet().forEach(key -> {
            com.google.protobuf.Value value = (com.google.protobuf.Value)map.get(key);
            values.put(key, Convert.convertAny(value));
        });
        return new MutableStructure(values);
    }

    public static com.google.protobuf.Value convertList(List<Value> values) {
        ListValue list = ListValue.newBuilder().addAllValues((Iterable)values.stream().map(v -> Convert.convertAny(v)).collect(Collectors.toList())).build();
        return com.google.protobuf.Value.newBuilder().setListValue(list).build();
    }

    public static Value convertList(ListValue protobuf) {
        return new Value(protobuf.getValuesList().stream().map(p -> Convert.convertAny(p)).collect(Collectors.toList()));
    }

    public static com.google.protobuf.Value convertPrimitive(Value value) {
        Value.Builder builder = com.google.protobuf.Value.newBuilder();
        if (value.isBoolean()) {
            builder.setBoolValue(value.asBoolean().booleanValue());
        } else if (value.isString()) {
            builder.setStringValue(value.asString());
        } else if (value.isNumber()) {
            builder.setNumberValue(value.asDouble().doubleValue());
        } else {
            builder.setNullValue(NullValue.NULL_VALUE);
        }
        return builder.build();
    }

    public static Value convertPrimitive(com.google.protobuf.Value protobuf) {
        Value value = protobuf.hasBoolValue() ? new Value(Boolean.valueOf(protobuf.getBoolValue())) : (protobuf.hasStringValue() ? new Value(protobuf.getStringValue()) : (protobuf.hasNumberValue() ? new Value(Double.valueOf(protobuf.getNumberValue())) : new Value()));
        return value;
    }

    public static <T> T getField(Message message, String name) {
        return (T)message.getField(Convert.getFieldDescriptor(message, name));
    }

    public static Descriptors.FieldDescriptor getFieldDescriptor(Message message, String name) {
        return message.getDescriptorForType().findFieldByName(name);
    }
}

