/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.common.nameresolvers;

import dev.openfeature.contrib.providers.flagd.resolver.common.nameresolvers.EnvoyResolver;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.URI;

public class EnvoyResolverProvider
extends NameResolverProvider {
    static final String ENVOY_SCHEME = "envoy";

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 5;
    }

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (!ENVOY_SCHEME.equals(targetUri.getScheme())) {
            return null;
        }
        if (!EnvoyResolverProvider.isValidPath(targetUri.getPath()) || targetUri.getHost() == null || targetUri.getPort() == -1) {
            throw new IllegalArgumentException("Incorrectly formatted target uri; expected: 'envoy:[//]<proxy-agent-host>:<proxy-agent-port>/<service-name>';but was '" + targetUri + "'");
        }
        return new EnvoyResolver(targetUri);
    }

    public String getDefaultScheme() {
        return ENVOY_SCHEME;
    }

    private static boolean isValidPath(String path) {
        return !path.isEmpty() && !path.substring(1).isEmpty() && !path.substring(1).contains("/");
    }
}

