/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.grpc;

import com.google.protobuf.Value;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.Cache;
import dev.openfeature.flagd.grpc.evaluation.Evaluation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(justification="cache needs to be read and write by multiple objects")
class EventStreamObserver
implements StreamObserver<Evaluation.EventStreamResponse> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventStreamObserver.class);
    private final BiConsumer<Boolean, List<String>> onConnectionEvent;
    private final Supplier<Boolean> shouldRetrySilently;
    private final Object sync;
    private final Cache cache;

    EventStreamObserver(Object sync, Cache cache, BiConsumer<Boolean, List<String>> onConnectionEvent, Supplier<Boolean> shouldRetrySilently) {
        this.sync = sync;
        this.cache = cache;
        this.onConnectionEvent = onConnectionEvent;
        this.shouldRetrySilently = shouldRetrySilently;
    }

    public void onNext(Evaluation.EventStreamResponse value) {
        switch (value.getType()) {
            case "configuration_change": {
                this.handleConfigurationChangeEvent(value);
                break;
            }
            case "provider_ready": {
                this.handleProviderReadyEvent();
                break;
            }
            default: {
                log.debug("unhandled event type {}", (Object)value.getType());
            }
        }
    }

    public void onError(Throwable throwable) {
        if (Boolean.TRUE.equals(this.shouldRetrySilently.get())) {
            log.debug("Event stream error, trying to recover", throwable);
        } else {
            log.error("Event stream error", throwable);
            if (this.cache.getEnabled().booleanValue()) {
                this.cache.clear();
            }
            this.onConnectionEvent.accept(false, Collections.emptyList());
        }
        this.handleEndOfStream();
    }

    public void onCompleted() {
        if (this.cache.getEnabled().booleanValue()) {
            this.cache.clear();
        }
        this.onConnectionEvent.accept(false, Collections.emptyList());
        this.handleEndOfStream();
    }

    private void handleConfigurationChangeEvent(Evaluation.EventStreamResponse value) {
        ArrayList<String> changedFlags = new ArrayList<String>();
        boolean cachingEnabled = this.cache.getEnabled();
        Map data = value.getData().getFieldsMap();
        Value flagsValue = (Value)data.get("flags");
        if (flagsValue == null) {
            if (cachingEnabled) {
                this.cache.clear();
            }
        } else {
            Map flags = flagsValue.getStructValue().getFieldsMap();
            this.cache.getEnabled();
            for (String flagKey : flags.keySet()) {
                changedFlags.add(flagKey);
                if (!cachingEnabled) continue;
                this.cache.remove(flagKey);
            }
        }
        this.onConnectionEvent.accept(true, changedFlags);
    }

    private void handleProviderReadyEvent() {
        this.onConnectionEvent.accept(true, Collections.emptyList());
        if (this.cache.getEnabled().booleanValue()) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEndOfStream() {
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }
}

