/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.grpc;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.common.ChannelBuilder;
import dev.openfeature.contrib.providers.flagd.resolver.common.ConnectionEvent;
import dev.openfeature.contrib.providers.flagd.resolver.common.Util;
import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.BackoffStrategies;
import dev.openfeature.contrib.providers.flagd.resolver.common.backoff.GrpcStreamConnectorBackoffService;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.EventStreamObserver;
import dev.openfeature.contrib.providers.flagd.resolver.grpc.cache.Cache;
import dev.openfeature.flagd.grpc.evaluation.Evaluation;
import dev.openfeature.flagd.grpc.evaluation.ServiceGrpc;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(justification="cache needs to be read and write by multiple objects")
public class GrpcConnector {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcConnector.class);
    private final Object sync = new Object();
    private final ServiceGrpc.ServiceBlockingStub serviceBlockingStub;
    private final ServiceGrpc.ServiceStub serviceStub;
    private final ManagedChannel channel;
    private final long deadline;
    private final long streamDeadlineMs;
    private final Cache cache;
    private final Consumer<ConnectionEvent> onConnectionEvent;
    private final Supplier<Boolean> connectedSupplier;
    private final GrpcStreamConnectorBackoffService backoff;
    private Thread eventObserverThread;

    public GrpcConnector(FlagdOptions options, Cache cache, Supplier<Boolean> connectedSupplier, Consumer<ConnectionEvent> onConnectionEvent) {
        this.channel = ChannelBuilder.nettyChannel(options);
        this.serviceStub = ServiceGrpc.newStub((Channel)this.channel);
        this.serviceBlockingStub = ServiceGrpc.newBlockingStub((Channel)this.channel);
        this.deadline = options.getDeadline();
        this.streamDeadlineMs = options.getStreamDeadlineMs();
        this.cache = cache;
        this.onConnectionEvent = onConnectionEvent;
        this.connectedSupplier = connectedSupplier;
        this.backoff = new GrpcStreamConnectorBackoffService(BackoffStrategies.maxRetriesWithExponentialTimeBackoffStrategy(options.getMaxEventStreamRetries(), options.getRetryBackoffMs()));
    }

    public void initialize() throws Exception {
        this.eventObserverThread = new Thread(this::observeEventStream);
        this.eventObserverThread.setDaemon(true);
        this.eventObserverThread.start();
        Util.busyWaitAndCheck(this.deadline, this.connectedSupplier);
    }

    public void shutdown() throws Exception {
        if (this.eventObserverThread != null) {
            this.eventObserverThread.interrupt();
        }
        try {
            if (this.channel != null && !this.channel.isShutdown()) {
                this.channel.shutdown();
                this.channel.awaitTermination(this.deadline, TimeUnit.MILLISECONDS);
            }
            this.cache.clear();
        }
        catch (Throwable throwable) {
            this.cache.clear();
            if (this.channel != null && !this.channel.isShutdown()) {
                this.channel.shutdownNow();
                this.channel.awaitTermination(this.deadline, TimeUnit.MILLISECONDS);
                log.warn(String.format("Unable to shut down channel by %d deadline", this.deadline));
            }
            this.onConnectionEvent.accept(new ConnectionEvent(false));
            throw throwable;
        }
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdownNow();
            this.channel.awaitTermination(this.deadline, TimeUnit.MILLISECONDS);
            log.warn(String.format("Unable to shut down channel by %d deadline", this.deadline));
        }
        this.onConnectionEvent.accept(new ConnectionEvent(false));
    }

    public ServiceGrpc.ServiceBlockingStub getResolver() {
        return (ServiceGrpc.ServiceBlockingStub)this.serviceBlockingStub.withDeadlineAfter(this.deadline, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void observeEventStream() {
        while (this.backoff.shouldRetry()) {
            EventStreamObserver responseObserver = new EventStreamObserver(this.sync, this.cache, this::onConnectionEvent, this.backoff::shouldRetrySilently);
            ServiceGrpc.ServiceStub localServiceStub = this.serviceStub;
            if (this.streamDeadlineMs > 0L) {
                localServiceStub = (ServiceGrpc.ServiceStub)localServiceStub.withDeadlineAfter(this.streamDeadlineMs, TimeUnit.MILLISECONDS);
            }
            localServiceStub.eventStream(Evaluation.EventStreamRequest.getDefaultInstance(), responseObserver);
            try {
                Object object = this.sync;
                synchronized (object) {
                    this.sync.wait();
                }
            }
            catch (InterruptedException e) {
                log.debug("interruption while waiting for condition", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            try {
                this.backoff.waitUntilNextAttempt();
            }
            catch (InterruptedException e) {
                log.warn("interrupted while restarting gRPC Event Stream");
                Thread.currentThread().interrupt();
            }
        }
        log.error("failed to connect to event stream, exhausted retries");
        this.onConnectionEvent(false, Collections.emptyList());
    }

    private void onConnectionEvent(boolean connected, List<String> changedFlags) {
        if (connected) {
            this.backoff.reset();
        }
        this.onConnectionEvent.accept(new ConnectionEvent(connected, changedFlags));
    }
}

