/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process.targeting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.expressions.PreEvaluatedArgumentsExpression;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.semver4j.Semver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SemVer
implements PreEvaluatedArgumentsExpression {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SemVer.class);
    private static final String EQ = "=";
    private static final String NEQ = "!=";
    private static final String LT = "<";
    private static final String LTE = "<=";
    private static final String GT = ">";
    private static final String GTE = ">=";
    private static final String MAJOR = "^";
    private static final String MINOR = "~";
    private static final Set<String> OPS = new HashSet<String>();

    SemVer() {
    }

    public String key() {
        return "sem_ver";
    }

    public Object evaluate(List arguments, Object data) throws JsonLogicEvaluationException {
        if (arguments.size() != 3) {
            log.debug("Incorrect number of arguments for sem_ver operator");
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            if (arguments.get(i) instanceof String) continue;
            log.debug("Invalid argument type. Require Strings");
            return null;
        }
        Semver arg1Parsed = Semver.parse((String)((String)arguments.get(0)));
        if (arg1Parsed == null) {
            log.debug("Argument one is not a valid SemVer");
            return null;
        }
        String arg2Parsed = (String)arguments.get(1);
        if (!OPS.contains(arg2Parsed)) {
            log.debug(String.format("Not valid operator in argument 2. Received: %s", arg2Parsed));
            return null;
        }
        Semver arg3Parsed = Semver.parse((String)((String)arguments.get(2)));
        if (arg3Parsed == null) {
            log.debug("Argument three is not a valid SemVer");
            return null;
        }
        return SemVer.compare(arg2Parsed, arg1Parsed, arg3Parsed);
    }

    private static boolean compare(String operator, Semver arg1, Semver arg2) throws JsonLogicEvaluationException {
        int comp = arg1.compareTo(arg2);
        switch (operator) {
            case "=": {
                return comp == 0;
            }
            case "!=": {
                return comp != 0;
            }
            case "<": {
                return comp < 0;
            }
            case "<=": {
                return comp <= 0;
            }
            case ">": {
                return comp > 0;
            }
            case ">=": {
                return comp >= 0;
            }
            case "^": {
                return arg1.getMajor() == arg2.getMajor();
            }
            case "~": {
                return arg1.getMinor() == arg2.getMinor() && arg1.getMajor() == arg2.getMajor();
            }
        }
        throw new JsonLogicEvaluationException(String.format("Unsupported operator received. Operator: %s", operator));
    }

    static {
        OPS.add(EQ);
        OPS.add(NEQ);
        OPS.add(LT);
        OPS.add(LTE);
        OPS.add(GT);
        OPS.add(GTE);
        OPS.add(MAJOR);
        OPS.add(MINOR);
    }
}

